/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.FacadeListPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Collaboration;

public class UMLRTProtocolMessageEditorFactory
extends FacadeListPropertyEditorFactory<UMLRTProtocolMessage> {
    public static final String SINGLE_PROTOCOL_MESSAGE = "Single ProtocolMessage";
    public static final String UML_RT = "uml-rt";
    private final RTMessageKind kind;

    public UMLRTProtocolMessageEditorFactory(EReference referenceIn, RTMessageKind kind, IObservableList<UMLRTProtocolMessage> modelProperty) {
        super(referenceIn, modelProperty);
        this.kind = kind;
    }

    @Override
    protected CreationContext basicGetCreationContext(Object element) {
        if (element instanceof UMLRTProtocol) {
            element = this.basicGetCreationContext(((UMLRTProtocol)element).toUML());
        } else if (element instanceof Collaboration) {
            element = ProtocolUtils.getMessageSet((Collaboration)((Collaboration)element), (RTMessageKind)this.kind);
        }
        return super.basicGetCreationContext(element);
    }

    public String getCreationDialogTitle() {
        switch (this.kind) {
            case OUT: {
                return Messages.MessageSetOwnedProtocolMessageValueFactory_CreateOutProtocolMessageDialogTitle;
            }
            case IN: {
                return Messages.MessageSetOwnedProtocolMessageValueFactory_CreateInProtocolMessageDialogTitle;
            }
            case IN_OUT: {
                return Messages.MessageSetOwnedProtocolMessageValueFactory_CreateInOutProtocolMessageDialogTitle;
            }
        }
        return Messages.MessageSetOwnedProtocolMessageValueFactory_CreateDialogTitle;
    }

    public String getEditionDialogTitle(Object objectToEdit) {
        switch (this.kind) {
            case OUT: {
                return Messages.MessageSetOwnedProtocolMessageValueFactory_EditOutProtocolMessageDialogTitle;
            }
            case IN: {
                return Messages.MessageSetOwnedProtocolMessageValueFactory_EditInProtocolMessageDialogTitle;
            }
            case IN_OUT: {
                return Messages.MessageSetOwnedProtocolMessageValueFactory_EditInOutProtocolMessageDialogTitle;
            }
        }
        return Messages.MessageSetOwnedProtocolMessageValueFactory_EditDialogTitle;
    }

    @Override
    protected Object doCreateObject(Control widget, Object context) {
        UMLRTProtocol protocol = (UMLRTProtocol)this.asUMLRT(context);
        Set others = protocol.getMessages(this.kind, true).stream().map(UMLRTProtocolMessage::toUML).collect(Collectors.toSet());
        StringBuilder baseName = new StringBuilder(15);
        baseName.append(this.kind.getLiteral()).append("ProtocolMessage");
        baseName.setCharAt(0, Character.toUpperCase(baseName.charAt(0)));
        String autoName = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)baseName.toString(), others);
        UMLRTProtocolMessage result = protocol.createMessage(this.kind, autoName);
        return this.createObject(widget, context, this.asUML(result));
    }

    @Override
    protected Set<View> getCreationDialogViews() {
        String contextName = UML_RT;
        String viewName = SINGLE_PROTOCOL_MESSAGE;
        Context context = ConfigurationManager.getInstance().getContext(contextName);
        for (View view : context.getViews()) {
            if (!viewName.equals(view.getName())) continue;
            return Collections.singleton(view);
        }
        return Collections.emptySet();
    }
}

