/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.providers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class TypeNameResolutionHelper
extends NameResolutionHelper {
    public TypeNameResolutionHelper(TypedElement element) {
        super(element.getNamespace(), UMLPackage.Literals.TYPE);
    }

    protected void computeAllNames() {
        this.computeNames("", this.scope, true);
        Namespace enclosingNamespace = this.scope.getNamespace();
        String prefix = "";
        while (enclosingNamespace != null) {
            prefix = "";
            this.computeNames(prefix, enclosingNamespace, false);
            enclosingNamespace = enclosingNamespace.getNamespace();
        }
        TreeIterator iter = EcoreUtil.getAllProperContents((ResourceSet)EMFHelper.getResourceSet((EObject)this.scope), (boolean)false);
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof Package && !(next instanceof Profile)) {
                Package package_ = (Package)next;
                prefix = package_.getQualifiedName();
                if (prefix == null) continue;
                prefix = String.valueOf(prefix) + "::";
                this.computeNames(prefix, (Namespace)package_, false);
                continue;
            }
            if (next instanceof Resource) continue;
            iter.prune();
        }
    }

    public List<Object> getMatchingElements(String aString) {
        if (this.allNames == null) {
            this.allNames = new HashMap();
            this.computeAllNames();
        }
        HashSet result = new HashSet();
        for (Map.Entry current : this.allNames.entrySet()) {
            if (!Strings.isNullOrEmpty((String)aString) && !((String)current.getKey()).startsWith(aString) && !TypeNameResolutionHelper.lastSegmentStartsWith((String)current.getKey(), aString)) continue;
            result.addAll((Collection)current.getValue());
        }
        return new ArrayList<Object>(result);
    }

    static boolean lastSegmentStartsWith(String qualifiedName, String prefix) {
        boolean result = false;
        int index = qualifiedName.lastIndexOf("::");
        if (index >= 0) {
            result = qualifiedName.length() - (index += "::".length()) >= prefix.length() && qualifiedName.substring(index).startsWith(prefix);
        }
        return result;
    }
}

