/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.UMLRTExtModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.RTEnumRadioValueEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Vertex;

public class RTTransitionKindPropertyEditor
extends AbstractPropertyEditor {
    protected RTEnumRadioValueEditor kindValueEditor;

    public RTTransitionKindPropertyEditor(Composite parent, int style) {
        super((AbstractValueEditor)new RTEnumRadioValueEditor(parent, style));
        this.kindValueEditor = (RTEnumRadioValueEditor)this.valueEditor;
    }

    protected void applyReadOnly(boolean readOnly) {
        super.applyReadOnly(readOnly);
        if (!readOnly) {
            PseudostateKind pseudoKind;
            ModelElement element = this.input.getModelElement(this.propertyPath);
            Transition transition = (Transition)((UMLRTExtModelElement)element).getSource();
            Vertex source = transition.getSource();
            Vertex target = transition.getTarget();
            TransitionKind kind = transition.getKind();
            if (source instanceof Pseudostate && !PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)(pseudoKind = ((Pseudostate)source).getKind())) && !PseudostateKind.EXIT_POINT_LITERAL.equals((Object)pseudoKind)) {
                Stream.of(TransitionKind.values()).filter(k -> k != kind).forEach(ev -> this.kindValueEditor.setReadOnly(ev, false));
                return;
            }
            TransitionKind[] transitionKindArray = TransitionKind.values();
            int n = transitionKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransitionKind targetKind = transitionKindArray[n2];
                boolean isEditable = this.isEditable(transition, (EObject)source, (EObject)target, kind, targetKind);
                this.kindValueEditor.setReadOnly(targetKind, isEditable);
                ++n2;
            }
        }
    }

    private boolean isEditable(Transition transition, EObject source, EObject target, TransitionKind sourceKind, TransitionKind targetKind) {
        TransitionKind expectedKind = TransitionUtils.getTransitionKind((Transition)transition, (EObject)source, (EObject)target);
        return expectedKind == targetKind;
    }

    protected void doBinding() {
        this.kindValueEditor.setProviders(this.input.getContentProvider(this.propertyPath), this.input.getLabelProvider(this.propertyPath));
        super.doBinding();
    }
}

