/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.uml2.uml.AggregationKind;

public enum UMLRTCapsulePartKind implements Enumerator
{
    FIXED(0, "fixed", "fixed"),
    OPTIONAL(1, "optional", "optional"),
    PLUG_IN(2, "plug_in", "plug-in"),
    NULL(3, "null", "null");

    public static final int FIXED_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    public static final int PLUG_IN_VALUE = 2;
    public static final int NULL_VALUE = 3;
    private static final UMLRTCapsulePartKind[] VALUES_ARRAY;
    public static final List<UMLRTCapsulePartKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UMLRTCapsulePartKind[]{FIXED, OPTIONAL, PLUG_IN, NULL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UMLRTCapsulePartKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UMLRTCapsulePartKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UMLRTCapsulePartKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UMLRTCapsulePartKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UMLRTCapsulePartKind get(int value) {
        switch (value) {
            case 0: {
                return FIXED;
            }
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return PLUG_IN;
            }
            case 3: {
                return NULL;
            }
        }
        return null;
    }

    private UMLRTCapsulePartKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isRequired() {
        return this == FIXED;
    }

    public boolean isComposite() {
        return this == FIXED || this == OPTIONAL;
    }

    public UMLRTCapsulePartKind setRequired(boolean required) {
        if (required == this.isRequired()) {
            return this;
        }
        switch (this) {
            case OPTIONAL: {
                return FIXED;
            }
            case FIXED: {
                return OPTIONAL;
            }
            case PLUG_IN: {
                return FIXED;
            }
        }
        return NULL;
    }

    public UMLRTCapsulePartKind setComposite(boolean composite) {
        if (composite == this.isComposite()) {
            return this;
        }
        switch (this) {
            case OPTIONAL: {
                return PLUG_IN;
            }
            case PLUG_IN: {
                return OPTIONAL;
            }
        }
        return NULL;
    }

    public static UMLRTCapsulePartKind get(int lowerBound, int upperBound, AggregationKind aggregation) {
        UMLRTCapsulePartKind result = NULL;
        if (lowerBound > 0 && upperBound > 0) {
            result = FIXED;
        } else if (lowerBound == 0 || upperBound == -1) {
            switch (aggregation) {
                case COMPOSITE_LITERAL: {
                    result = OPTIONAL;
                    break;
                }
                case SHARED_LITERAL: {
                    result = PLUG_IN;
                    break;
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.literal;
    }
}

