/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.util.Pair;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

class FacadeType<T extends Element, S extends EObject, F extends FacadeObjectImpl> {
    static final EClass NO_STEREOTYPE = null;
    private final Class<F> instanceClass;
    private final EClass umlMetaclass;
    private final EClass stereotype;
    private final Function<T, F> facadeFunction;
    private final UnaryOperator<F> redefinitionOperator;
    private final Function<T, F> facadeFactory;

    FacadeType(Class<F> instanceClass, EClass umlMetaclass, EClass stereotype, Function<T, F> facadeFunction, UnaryOperator<F> redefinitionOperator, Supplier<F> facadeFactory) {
        this(instanceClass, umlMetaclass, stereotype, facadeFunction, redefinitionOperator, (T __) -> (FacadeObjectImpl)facadeFactory.get());
    }

    FacadeType(Class<F> instanceClass, EClass umlMetaclass, EClass stereotype, Function<T, F> facadeFunction, UnaryOperator<F> redefinitionOperator, Function<T, F> facadeFactory) {
        this.instanceClass = instanceClass;
        this.umlMetaclass = umlMetaclass;
        this.stereotype = stereotype;
        this.facadeFunction = facadeFunction;
        this.redefinitionOperator = redefinitionOperator;
        this.facadeFactory = facadeFactory;
    }

    F getFacade(T element) {
        return (F)(this.umlMetaclass.isInstance(element) ? (FacadeObjectImpl)this.facadeFunction.apply(element) : null);
    }

    F getRedefinition(F facade) {
        return (F)((FacadeObjectImpl)this.redefinitionOperator.apply(facade));
    }

    boolean redefines(FacadeObject self, FacadeObject other) {
        boolean result = false;
        while (!result && self != null) {
            result = self == other;
            self = this.getRedefinition(this.cast(self));
        }
        return result;
    }

    F cast(Object object) {
        return (F)((FacadeObjectImpl)this.instanceClass.cast(object));
    }

    FacadeObjectImpl.BasicFacadeAdapter<F> getAdapter(T element) {
        return (FacadeObjectImpl.BasicFacadeAdapter)EcoreUtil.getExistingAdapter(element, this.instanceClass);
    }

    FacadeObjectImpl.BasicFacadeAdapter<? extends FacadeObjectImpl> createAdapter(T element) {
        FacadeObjectImpl.BasicFacadeAdapter<? extends FacadeObjectImpl> result = null;
        FacadeObjectImpl facade = null;
        if (this.stereotype == NO_STEREOTYPE) {
            facade = (FacadeObjectImpl)this.facadeFactory.apply(element);
            if (facade != null) {
                result = facade.createFacadeAdapter();
                result.addAdapter((Notifier)element);
                facade.init((Element)element, null);
            }
        } else {
            S application = this.getStereotypeApplication(element);
            if (application != null && (facade = (FacadeObjectImpl)this.facadeFactory.apply(element)) != null) {
                result = facade.createFacadeAdapter();
                result.addAdapter((Notifier)element);
                facade.init((Element)element, (EObject)application);
            }
        }
        return result;
    }

    F getFacade(FacadeObjectImpl.BasicFacadeAdapter<? extends FacadeObjectImpl> adapter) {
        return (F)((FacadeObjectImpl)this.instanceClass.cast(adapter.get()));
    }

    S applyStereotype(T element) {
        return (S)(this.stereotype == null ? null : UMLUtil.StereotypeApplicationHelper.getInstance(element).applyStereotype(element, this.stereotype));
    }

    S getStereotypeApplication(T element) {
        return (S)(this.stereotype == null ? null : UMLUtil.getStereotypeApplication(element, (Class)this.stereotype.getInstanceClass()));
    }

    public String toString() {
        return String.format("FacadeType(name=%s)", this.instanceClass.getSimpleName());
    }

    static final class Union<T extends Element, F extends FacadeObjectImpl>
    extends FacadeType<T, EObject, F> {
        private final Supplier<? extends List<FacadeType<? extends T, ? extends EObject, ? extends F>>> types;

        @SafeVarargs
        Union(Class<F> instanceClass, EClass umlMetaclass, FacadeType<? extends T, ? extends EObject, ? extends F> type1, FacadeType<? extends T, ? extends EObject, ? extends F> type2, FacadeType<? extends T, ? extends EObject, ? extends F> ... rest) {
            this(instanceClass, umlMetaclass, Union.asList(type1, type2, rest));
        }

        Union(Class<F> instanceClass, EClass umlMetaclass, List<FacadeType<? extends T, ? extends EObject, ? extends F>> types) {
            this(instanceClass, umlMetaclass, () -> types);
        }

        Union(Class<F> instanceClass, EClass umlMetaclass, Supplier<? extends List<FacadeType<? extends T, ? extends EObject, ? extends F>>> types) {
            super(instanceClass, umlMetaclass, (EClass)null, Union.unionFacadeFunction(types), Union.unionRedefinitionOperator(types), null);
            this.types = types;
        }

        @SafeVarargs
        private static <E> List<E> asList(E e1, E e2, E ... rest) {
            if (rest.length == 0) {
                return new Pair<E>(e1, e2);
            }
            ArrayList<E> result = new ArrayList<E>(2 + rest.length);
            result.add(e1);
            result.add(e2);
            int i = 0;
            while (i < rest.length) {
                result.add(rest[i]);
                ++i;
            }
            return result;
        }

        final <V> V evaluate(BiFunction<FacadeType<T, ?, F>, T, V> operation, T element) {
            return this.types.get().stream().filter(type -> ((FacadeType)type).umlMetaclass.isInstance(element)).map(type -> operation.apply((FacadeType)type, element)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        FacadeObjectImpl.BasicFacadeAdapter<F> getAdapter(T element) {
            return this.evaluate(FacadeType::getAdapter, element);
        }

        @Override
        FacadeObjectImpl.BasicFacadeAdapter<? extends FacadeObjectImpl> createAdapter(T element) {
            return this.evaluate(FacadeType::createAdapter, element);
        }

        @Override
        EObject applyStereotype(T element) {
            return (EObject)this.evaluate(FacadeType::applyStereotype, element);
        }

        @Override
        EObject getStereotypeApplication(T element) {
            return (EObject)this.evaluate(FacadeType::getStereotypeApplication, element);
        }

        private static <T extends Element, F extends FacadeObjectImpl> Function<T, F> unionFacadeFunction(Supplier<? extends List<FacadeType<? extends T, ? extends EObject, ? extends F>>> types) {
            return element -> ((List)types.get()).stream().filter(type -> ((FacadeType)type).umlMetaclass.isInstance(element)).map(type -> ((FacadeType)type).facadeFunction).map(f -> (FacadeObjectImpl)f.apply(element)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        private static <T extends Element, F extends FacadeObjectImpl> UnaryOperator<F> unionRedefinitionOperator(Supplier<? extends List<FacadeType<? extends T, ? extends EObject, ? extends F>>> types) {
            return facade -> ((List)types.get()).stream().filter(type -> ((FacadeType)type).instanceClass.isInstance(facade)).map(type -> ((FacadeType)type).redefinitionOperator).map(f -> (FacadeObjectImpl)f.apply(facade)).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }
}

