/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTConnector;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTReplicatedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLRTConnectorImpl
extends UMLRTNamedElementImpl
implements UMLRTConnector {
    protected static final int SOURCE_REPLICATION_FACTOR_EDEFAULT = 0;
    protected static final int TARGET_REPLICATION_FACTOR_EDEFAULT = 0;
    static final FacadeType<Connector, RTConnector, UMLRTConnectorImpl> TYPE = new FacadeType(UMLRTConnectorImpl.class, UMLPackage.Literals.CONNECTOR, UMLRealTimePackage.Literals.RT_CONNECTOR, UMLRTConnectorImpl::getInstance, connector -> (UMLRTConnectorImpl)connector.getRedefinedConnector(), UMLRTConnectorImpl::new);

    protected UMLRTConnectorImpl() {
    }

    public static UMLRTConnectorImpl getInstance(Connector connector) {
        return UMLRTConnectorImpl.getFacade(connector, TYPE);
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.CONNECTOR;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTConnectorImpl> createFacadeAdapter() {
        return new ConnectorAdapter<UMLRTConnectorImpl>(this);
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        UMLRTConnector redefinedConnector = this.getRedefinedConnector();
        if (redefinedConnector != null) {
            return redefinedConnector;
        }
        return super.getRedefinedElement();
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTCapsule capsule = this.getCapsule();
        if (capsule != null) {
            return capsule;
        }
        return super.getRedefinitionContext();
    }

    @Override
    public UMLRTConnector getRedefinedConnector() {
        UMLRTConnector result;
        if (this.toUML() instanceof InternalUMLRTElement) {
            Connector superConnector = (Connector)((InternalUMLRTElement)this.toUML()).rtGetRedefinedElement();
            result = UMLRTConnector.getInstance(superConnector);
        } else {
            UMLRTNamedElement redef = super.getRedefinedElement();
            result = redef instanceof UMLRTConnector ? (UMLRTConnector)redef : null;
        }
        return result;
    }

    @Override
    public UMLRTCapsule getCapsule() {
        return UMLRTCapsule.getInstance((Class)this.toUML().getNamespace());
    }

    @Override
    public UMLRTPort getSource() {
        ConnectorEnd sourceEnd = this.umlEnd(0);
        return this.resolvePort(sourceEnd);
    }

    ConnectorEnd umlEnd(int index) {
        ConnectorEnd result = null;
        EList ends = this.toUML().getEnds();
        if (ends.size() > index) {
            result = (ConnectorEnd)ends.get(index);
        }
        return result;
    }

    private UMLRTPort resolvePort(ConnectorEnd end) {
        UMLRTPort result;
        Port uml = end == null ? null : (end.getRole() instanceof Port ? (Port)end.getRole() : null);
        UMLRTPort uMLRTPort = result = uml == null ? null : UMLRTPort.getInstance(uml);
        if (result != null && result.getCapsule() != this.getCapsule()) {
            UMLRTPort inherited = result;
            result = this.getCapsule().getPorts(true).stream().filter(p -> p.redefines(inherited)).findAny().orElse(result);
        }
        return result;
    }

    @Override
    public void setSource(UMLRTPort newSource) {
        ConnectorEnd sourceEnd = this.umlEnd(0);
        if (sourceEnd == null) {
            throw new IllegalStateException("no source end");
        }
        sourceEnd.setRole((ConnectableElement)(newSource == null ? null : newSource.toUML()));
    }

    @Override
    public UMLRTCapsulePart getSourcePartWithPort() {
        ConnectorEnd sourceEnd = this.umlEnd(0);
        return this.resolvePartWithPort(sourceEnd);
    }

    private UMLRTCapsulePart resolvePartWithPort(ConnectorEnd end) {
        UMLRTCapsulePart result = null;
        if (end != null && end.getPartWithPort() != null && (result = UMLRTCapsulePart.getInstance(end.getPartWithPort())) != null && result.getCapsule() != this.getCapsule()) {
            UMLRTCapsulePart inherited = result;
            result = this.getCapsule().getCapsuleParts(true).stream().filter(p -> p.redefines(inherited)).findAny().orElse(result);
        }
        return result;
    }

    @Override
    public void setSourcePartWithPort(UMLRTCapsulePart newSourcePartWithPort) {
        ConnectorEnd sourceEnd = this.umlEnd(0);
        if (sourceEnd == null) {
            throw new IllegalStateException("no source end");
        }
        sourceEnd.setPartWithPort(newSourcePartWithPort == null ? null : newSourcePartWithPort.toUML());
    }

    @Override
    public int getSourceReplicationFactor() {
        ConnectorEnd sourceEnd = this.umlEnd(0);
        return UMLRTReplicatedElementImpl.getReplicationFactor(sourceEnd == null ? null : sourceEnd.getUpperValue());
    }

    @Override
    public void setSourceReplicationFactor(int newSourceReplicationFactor) {
        ConnectorEnd sourceEnd = this.umlEnd(0);
        if (sourceEnd == null) {
            throw new IllegalStateException("no source end");
        }
        sourceEnd.setLower(newSourceReplicationFactor);
        sourceEnd.setUpper(newSourceReplicationFactor);
    }

    @Override
    public UMLRTPort getTarget() {
        ConnectorEnd targetEnd = this.umlEnd(1);
        return this.resolvePort(targetEnd);
    }

    @Override
    public void setTarget(UMLRTPort newTarget) {
        ConnectorEnd targetEnd = this.umlEnd(1);
        if (targetEnd == null) {
            throw new IllegalStateException("no target end");
        }
        targetEnd.setRole((ConnectableElement)(newTarget == null ? null : newTarget.toUML()));
    }

    @Override
    public UMLRTCapsulePart getTargetPartWithPort() {
        ConnectorEnd targetEnd = this.umlEnd(1);
        return this.resolvePartWithPort(targetEnd);
    }

    @Override
    public void setTargetPartWithPort(UMLRTCapsulePart newTargetPartWithPort) {
        ConnectorEnd targetEnd = this.umlEnd(1);
        if (targetEnd == null) {
            throw new IllegalStateException("no target end");
        }
        targetEnd.setPartWithPort(newTargetPartWithPort == null ? null : newTargetPartWithPort.toUML());
    }

    @Override
    public int getTargetReplicationFactor() {
        ConnectorEnd targetEnd = this.umlEnd(1);
        return UMLRTReplicatedElementImpl.getReplicationFactor(targetEnd == null ? null : targetEnd.getUpperValue());
    }

    @Override
    public void setTargetReplicationFactor(int newTargetReplicationFactor) {
        ConnectorEnd targetEnd = this.umlEnd(1);
        if (targetEnd == null) {
            throw new IllegalStateException("no target end");
        }
        targetEnd.setLower(newTargetReplicationFactor);
        targetEnd.setUpper(newTargetReplicationFactor);
    }

    @Override
    public Connector toUML() {
        return (Connector)super.toUML();
    }

    @Override
    public Stream<? extends UMLRTConnector> allRedefinitions() {
        Predicate<UMLRTConnector> excluded = UMLRTNamedElement::isExcluded;
        UMLRTCapsule capsule = this.getCapsule();
        return capsule == null ? Stream.of(this) : capsule.getHierarchy().map(c -> c.getRedefinitionOf(this)).filter(Objects::nonNull).filter(excluded.negate());
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getRedefinedConnector();
            }
            case 15: {
                return this.getCapsule();
            }
            case 16: {
                return this.getSource();
            }
            case 17: {
                return this.getSourcePartWithPort();
            }
            case 18: {
                return this.getSourceReplicationFactor();
            }
            case 19: {
                return this.getTarget();
            }
            case 20: {
                return this.getTargetPartWithPort();
            }
            case 21: {
                return this.getTargetReplicationFactor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setSource((UMLRTPort)newValue);
                return;
            }
            case 17: {
                this.setSourcePartWithPort((UMLRTCapsulePart)newValue);
                return;
            }
            case 18: {
                this.setSourceReplicationFactor((Integer)newValue);
                return;
            }
            case 19: {
                this.setTarget((UMLRTPort)newValue);
                return;
            }
            case 20: {
                this.setTargetPartWithPort((UMLRTCapsulePart)newValue);
                return;
            }
            case 21: {
                this.setTargetReplicationFactor((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setSource(null);
                return;
            }
            case 17: {
                this.setSourcePartWithPort(null);
                return;
            }
            case 18: {
                this.setSourceReplicationFactor(0);
                return;
            }
            case 19: {
                this.setTarget(null);
                return;
            }
            case 20: {
                this.setTargetPartWithPort(null);
                return;
            }
            case 21: {
                this.setTargetReplicationFactor(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 14: {
                return this.getRedefinedConnector() != null;
            }
            case 15: {
                return this.getCapsule() != null;
            }
            case 16: {
                return this.getSource() != null;
            }
            case 17: {
                return this.getSourcePartWithPort() != null;
            }
            case 18: {
                return this.getSourceReplicationFactor() != 0;
            }
            case 19: {
                return this.getTarget() != null;
            }
            case 20: {
                return this.getTargetPartWithPort() != null;
            }
            case 21: {
                return this.getTargetReplicationFactor() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.eIsSet(14);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(15);
    }

    protected static class ConnectorAdapter<F extends UMLRTConnectorImpl>
    extends UMLRTNamedElementImpl.NamedElementAdapter<F> {
        ConnectorAdapter(F facade) {
            super(facade);
        }

        @Override
        public void setTarget(Notifier newTarget) {
            MultiplicityElement mult;
            super.setTarget(newTarget);
            if (newTarget instanceof Connector) {
                ((Connector)newTarget).getEnds().forEach(this::adaptAdditional);
            } else if (newTarget instanceof MultiplicityElement && (mult = (MultiplicityElement)newTarget).getUpperValue() != null) {
                this.adaptAdditional((Notifier)mult.getUpperValue());
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof Connector) {
                this.unadaptAdditional();
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void handleObjectAdded(Notification msg, int position, EObject object) {
            if (msg.getFeature() == UMLPackage.Literals.CONNECTOR__END) {
                this.adaptAdditional((Notifier)object);
            }
            super.handleObjectAdded(msg, position, object);
        }

        @Override
        protected void handleObjectRemoved(Notification msg, int position, EObject object) {
            super.handleObjectRemoved(msg, position, object);
            if (msg.getFeature() == UMLPackage.Literals.CONNECTOR__END) {
                this.unadaptAdditional((Notifier)object);
            }
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, EObject oldObject, EObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.CONNECTOR__END) {
                this.unadaptAdditional((Notifier)oldObject);
                this.adaptAdditional((Notifier)newObject);
            } else if (msg.getFeature() == UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) {
                if (oldObject != null) {
                    this.unadaptAdditional((Notifier)oldObject);
                }
                if (newObject != null) {
                    this.adaptAdditional((Notifier)newObject);
                }
                boolean isSource = msg.getNotifier() == ((UMLRTConnectorImpl)this.get()).umlEnd(0);
                this.handleUpperBoundChanged(isSource, UMLRTReplicatedElementImpl.ReplicationAdapter.asIntegerBound(UMLRTReplicatedElementImpl.ReplicationAdapter.valueOf((ValueSpecification)oldObject)), UMLRTReplicatedElementImpl.ReplicationAdapter.asIntegerBound(UMLRTReplicatedElementImpl.ReplicationAdapter.valueOf((ValueSpecification)newObject)));
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, FacadeObject oldObject, FacadeObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.CONNECTOR_END__ROLE) {
                if (((UMLRTConnectorImpl)this.get()).eNotificationRequired()) {
                    boolean isSource = msg.getNotifier() == ((UMLRTConnectorImpl)this.get()).umlEnd(0);
                    EReference feature = isSource ? UMLRTUMLRTPackage.Literals.CONNECTOR__SOURCE : UMLRTUMLRTPackage.Literals.CONNECTOR__TARGET;
                    ((UMLRTConnectorImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)feature, (Object)oldObject, (Object)newObject));
                }
            } else if (msg.getFeature() == UMLPackage.Literals.CONNECTOR_END__PART_WITH_PORT) {
                if (((UMLRTConnectorImpl)this.get()).eNotificationRequired()) {
                    boolean isSource = msg.getNotifier() == ((UMLRTConnectorImpl)this.get()).umlEnd(0);
                    EReference feature = isSource ? UMLRTUMLRTPackage.Literals.CONNECTOR__SOURCE_PART_WITH_PORT : UMLRTUMLRTPackage.Literals.CONNECTOR__TARGET_PART_WITH_PORT;
                    ((UMLRTConnectorImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)feature, (Object)oldObject, (Object)newObject));
                }
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }

        @Override
        protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
            if (msg.getFeature() == UMLPackage.Literals.LITERAL_INTEGER__VALUE || msg.getFeature() == UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE || msg.getFeature() == UMLPackage.Literals.LITERAL_STRING__VALUE || msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && position == 0) {
                ValueSpecification bound = (ValueSpecification)msg.getNotifier();
                MultiplicityElement mult = (MultiplicityElement)bound.getOwner();
                boolean isSource = mult == ((UMLRTConnectorImpl)this.get()).umlEnd(0);
                this.handleUpperBoundChanged(isSource, UMLRTReplicatedElementImpl.ReplicationAdapter.asIntegerBound(oldValue), UMLRTReplicatedElementImpl.ReplicationAdapter.asIntegerBound(newValue));
            } else {
                super.handleValueReplaced(msg, position, oldValue, newValue);
            }
        }

        @Override
        protected void handleValueAdded(Notification msg, int position, Object value) {
            if (msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && position == 0) {
                ValueSpecification bound = (ValueSpecification)msg.getNotifier();
                MultiplicityElement mult = (MultiplicityElement)bound.getOwner();
                boolean isSource = mult == ((UMLRTConnectorImpl)this.get()).umlEnd(0);
                this.handleUpperBoundChanged(isSource, 1, UMLRTReplicatedElementImpl.ReplicationAdapter.asIntegerBound(value));
            } else {
                super.handleValueAdded(msg, position, value);
            }
        }

        @Override
        protected void handleValueRemoved(Notification msg, int position, Object value) {
            if (msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && ((OpaqueExpression)msg.getNotifier()).getBodies().isEmpty()) {
                ValueSpecification bound = (ValueSpecification)msg.getNotifier();
                MultiplicityElement mult = (MultiplicityElement)bound.getOwner();
                boolean isSource = mult == ((UMLRTConnectorImpl)this.get()).umlEnd(0);
                this.handleUpperBoundChanged(isSource, UMLRTReplicatedElementImpl.ReplicationAdapter.asIntegerBound(value), mult.getUpper());
            } else {
                super.handleValueRemoved(msg, position, value);
            }
        }

        protected void handleUpperBoundChanged(boolean isSource, int oldValue, int newValue) {
            if (((UMLRTConnectorImpl)this.get()).eNotificationRequired()) {
                EAttribute feature = isSource ? UMLRTUMLRTPackage.Literals.CONNECTOR__SOURCE_REPLICATION_FACTOR : UMLRTUMLRTPackage.Literals.CONNECTOR__TARGET_REPLICATION_FACTOR;
                ((UMLRTConnectorImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), 1, (EStructuralFeature)feature, oldValue, newValue));
            }
        }
    }
}

