/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Protocol;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTClassifier;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeReference;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.InternalFacadeEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTClassifierImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTProtocolMessageImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.CachedReference;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.FacadeContentsEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InternalFacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTProtocolImpl
extends UMLRTClassifierImpl
implements UMLRTProtocol {
    protected static final boolean IS_CONJUGATE_EDEFAULT = false;
    private static final String ANY_RECEIVE_EVENT_NAME = "*";
    static final FacadeType<Collaboration, Protocol, UMLRTProtocolImpl> TYPE = new FacadeType(UMLRTProtocolImpl.class, UMLPackage.Literals.COLLABORATION, UMLRealTimePackage.Literals.PROTOCOL, UMLRTProtocolImpl::getInstance, protocol -> (UMLRTProtocolImpl)protocol.getSuperProtocol(), UMLRTProtocolImpl::new);
    private static final Map<RTMessageKind, FacadeReference<Operation, EObject, UMLRTProtocolMessage, UMLRTProtocolMessageImpl>> MESSAGE_REFERENCES;
    private final boolean isConjugate;
    private final Supplier<UMLRTProtocol> conjugate;
    InternalFacadeEList<UMLRTProtocolMessage> inMessages;
    InternalFacadeEList<UMLRTProtocolMessage> outMessages;
    InternalFacadeEList<UMLRTProtocolMessage> inOutMessages;
    protected static final int[] SPECIFIC_ESUBSETS;
    protected static final int[] MESSAGE_ESUBSETS;
    protected static final int[] REDEFINABLE_ELEMENT_ESUBSETS;

    static {
        EnumMap<RTMessageKind, Integer> references = new EnumMap<RTMessageKind, Integer>(RTMessageKind.class);
        references.put(RTMessageKind.IN, 20);
        references.put(RTMessageKind.IN_OUT, 22);
        references.put(RTMessageKind.OUT, 21);
        MESSAGE_REFERENCES = new EnumMap<RTMessageKind, FacadeReference<Operation, EObject, UMLRTProtocolMessage, UMLRTProtocolMessageImpl>>(RTMessageKind.class);
        RTMessageKind.VALUES.forEach(kind -> {
            FacadeReference.Indirect<Operation, EObject, UMLRTProtocolMessage, UMLRTProtocolMessageImpl> indirect = MESSAGE_REFERENCES.put((RTMessageKind)kind, (FacadeReference<Operation, EObject, UMLRTProtocolMessage, UMLRTProtocolMessageImpl>)new FacadeReference.Indirect<Operation, EObject, UMLRTProtocolMessage, UMLRTProtocolMessageImpl>(UMLRTProtocolMessageImpl.TYPE, (Integer)references.get(kind), UMLRTProtocolMessage.class, UMLPackage.Literals.INTERFACE__OWNED_OPERATION, ExtUMLExtPackage.Literals.INTERFACE__IMPLICIT_OPERATION, UMLPackage.Literals.OPERATION, protocol -> UMLRTProtocolImpl.requireMessageSet((Collaboration)protocol, kind)));
        });
        SPECIFIC_ESUBSETS = new int[]{18};
        MESSAGE_ESUBSETS = new int[]{20, 21, 22};
        REDEFINABLE_ELEMENT_ESUBSETS = new int[]{19};
    }

    protected UMLRTProtocolImpl() {
        this.isConjugate = false;
        this.conjugate = new CachedReference<UMLRTProtocol>(() -> new UMLRTProtocolImpl(this));
    }

    UMLRTProtocolImpl(UMLRTProtocolImpl base) {
        this.isConjugate = true;
        this.conjugate = () -> base;
        this.init((Element)base.toUML(), base.toRT());
    }

    public static UMLRTProtocolImpl getInstance(Collaboration protocol) {
        return UMLRTProtocolImpl.getFacade(protocol, TYPE);
    }

    static boolean isRTMessageSet(Interface interface_) {
        return UMLRTProtocolImpl.getRTMessageSet(interface_) != null;
    }

    static RTMessageSet getRTMessageSet(Interface interface_) {
        return (RTMessageSet)UMLUtil.getStereotypeApplication((Element)interface_, RTMessageSet.class);
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTProtocolImpl> createFacadeAdapter() {
        return new ProtocolAdapter<UMLRTProtocolImpl>(this);
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.PROTOCOL;
    }

    @Override
    public String getName() {
        String result = super.getName();
        if (this.isConjugate()) {
            result = String.valueOf(result) + "~";
        }
        return result;
    }

    @Override
    public void setName(String newName) {
        if (newName != null && this.isConjugate()) {
            if (!newName.endsWith("~")) {
                throw new IllegalArgumentException("conjugate name must end with ~");
            }
            newName = newName.substring(0, newName.length() - 1);
        }
        super.setName(newName);
    }

    @Override
    public UMLRTClassifier getGeneral() {
        UMLRTProtocol superProtocol = this.getSuperProtocol();
        if (superProtocol != null) {
            return superProtocol;
        }
        return super.getGeneral();
    }

    @Override
    public List<UMLRTClassifier> getSpecifics() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            Resource eResource = this.eResource();
            List specifics = (List)cache.get(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.CLASSIFIER__SPECIFIC);
            if (specifics == null) {
                specifics = new DerivedUnionEObjectEList(UMLRTClassifier.class, (InternalEObject)this, 15, SPECIFIC_ESUBSETS);
                cache.put(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.CLASSIFIER__SPECIFIC, (Object)specifics);
            }
            return specifics;
        }
        return new DerivedUnionEObjectEList(UMLRTClassifier.class, (InternalEObject)this, 15, SPECIFIC_ESUBSETS);
    }

    @Override
    public List<UMLRTNamedElement> getRedefinableElements() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            Resource eResource = this.eResource();
            List redefinableElements = (List)cache.get(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.NAMED_ELEMENT__REDEFINABLE_ELEMENT);
            if (redefinableElements == null) {
                redefinableElements = new DerivedUnionEObjectEList(UMLRTNamedElement.class, (InternalEObject)this, 10, REDEFINABLE_ELEMENT_ESUBSETS);
                cache.put(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.NAMED_ELEMENT__REDEFINABLE_ELEMENT, (Object)redefinableElements);
            }
            return redefinableElements;
        }
        return new DerivedUnionEObjectEList(UMLRTNamedElement.class, (InternalEObject)this, 10, REDEFINABLE_ELEMENT_ESUBSETS);
    }

    @Override
    public UMLRTProtocol getSuperProtocol() {
        EList generals = this.toUML().getGenerals();
        return generals.isEmpty() || !(generals.get(0) instanceof Collaboration) ? null : UMLRTProtocol.getInstance((Collaboration)generals.get(0), this.isConjugate());
    }

    @Override
    public void setSuperProtocol(UMLRTProtocol newSuperProtocol) {
        UMLRTProtocolImpl.setGeneral(this.toUML(), newSuperProtocol == null ? null : newSuperProtocol.toUML());
    }

    @Override
    public void setGeneral(UMLRTClassifier general) {
        this.setSuperProtocol((UMLRTProtocol)general);
    }

    @Override
    public List<UMLRTProtocol> getSubProtocols() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            List<UMLRTProtocol> subProtools = (List<UMLRTProtocol>)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PROTOCOL__SUB_PROTOCOL);
            if (subProtools == null) {
                subProtools = this.doGetSubProtocols();
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PROTOCOL__SUB_PROTOCOL, subProtools);
            }
            return subProtools;
        }
        return this.doGetSubProtocols();
    }

    private List<UMLRTProtocol> doGetSubProtocols() {
        return (List)UMLRTProtocolImpl.specifics(this.toUML(), Collaboration.class).map(UMLRTProtocolImpl::getInstance).filter(Objects::nonNull).map(this::forConjugation).collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.PROTOCOL__SUB_PROTOCOL, list)));
    }

    @Override
    public UMLRTProtocol getSubProtocol(String name) {
        return this.getSubProtocol(name, false);
    }

    @Override
    public UMLRTProtocol getSubProtocol(String name, boolean ignoreCase) {
        for (UMLRTProtocol subProtocol : this.getSubProtocols()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(subProtocol.getName()) : !name.equals(subProtocol.getName()))) continue;
            return subProtocol;
        }
        return null;
    }

    @Override
    public List<UMLRTProtocolMessage> getInMessages() {
        if (this.inMessages == null) {
            this.inMessages = (InternalFacadeEList)((Object)this.getFacades(MESSAGE_REFERENCES.get(this.forConjugation(RTMessageKind.IN)), this.messageConjugation()));
        }
        return this.inMessages;
    }

    @Override
    public UMLRTProtocolMessage getInMessage(String name) {
        return this.getInMessage(name, false);
    }

    @Override
    public UMLRTProtocolMessage getInMessage(String name, boolean ignoreCase) {
        for (UMLRTProtocolMessage inMessage : this.getInMessages()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(inMessage.getName()) : !name.equals(inMessage.getName()))) continue;
            return inMessage;
        }
        return null;
    }

    @Override
    public List<UMLRTProtocolMessage> getOutMessages() {
        if (this.outMessages == null) {
            this.outMessages = (InternalFacadeEList)((Object)this.getFacades(MESSAGE_REFERENCES.get(this.forConjugation(RTMessageKind.OUT)), this.messageConjugation()));
        }
        return this.outMessages;
    }

    @Override
    public UMLRTProtocolMessage getOutMessage(String name) {
        return this.getOutMessage(name, false);
    }

    @Override
    public UMLRTProtocolMessage getOutMessage(String name, boolean ignoreCase) {
        for (UMLRTProtocolMessage outMessage : this.getOutMessages()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(outMessage.getName()) : !name.equals(outMessage.getName()))) continue;
            return outMessage;
        }
        return null;
    }

    @Override
    public List<UMLRTProtocolMessage> getInOutMessages() {
        if (this.inOutMessages == null) {
            this.inOutMessages = (InternalFacadeEList)((Object)this.getFacades(MESSAGE_REFERENCES.get(this.forConjugation(RTMessageKind.IN_OUT)), this.messageConjugation()));
        }
        return this.inOutMessages;
    }

    @Override
    public UMLRTProtocolMessage getInOutMessage(String name) {
        return this.getInOutMessage(name, false);
    }

    @Override
    public UMLRTProtocolMessage getInOutMessage(String name, boolean ignoreCase) {
        for (UMLRTProtocolMessage inOutMessage : this.getInOutMessages()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(inOutMessage.getName()) : !name.equals(inOutMessage.getName()))) continue;
            return inOutMessage;
        }
        return null;
    }

    @Override
    public List<UMLRTProtocolMessage> getMessages() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            Resource eResource = this.eResource();
            List messages = (List)cache.get(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.PROTOCOL__MESSAGE);
            if (messages == null) {
                messages = new DerivedUnionEObjectEList(UMLRTProtocolMessage.class, (InternalEObject)this, 19, MESSAGE_ESUBSETS);
                cache.put(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.PROTOCOL__MESSAGE, (Object)messages);
            }
            return messages;
        }
        return new DerivedUnionEObjectEList(UMLRTProtocolMessage.class, (InternalEObject)this, 19, MESSAGE_ESUBSETS);
    }

    @Override
    public UMLRTProtocolMessage getMessage(String name) {
        return this.getMessage(name, false);
    }

    @Override
    public UMLRTProtocolMessage getMessage(String name, boolean ignoreCase) {
        for (UMLRTProtocolMessage message : this.getMessages()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(message.getName()) : !name.equals(message.getName()))) continue;
            return message;
        }
        return null;
    }

    UMLRTProtocol forConjugation(UMLRTProtocol other) {
        return other != null && other != this && this.isConjugate() ? other.getConjugate() : other;
    }

    Stream<Interface> messageSets() {
        Package container = this.toUML().getNearestPackage();
        return container == null ? Stream.empty() : container.getOwnedTypes().stream().filter(Interface.class::isInstance).map(Interface.class::cast).filter(UMLRTProtocolImpl::isRTMessageSet);
    }

    Optional<Interface> getMessageSet(RTMessageKind kind) {
        return this.messageSets().map(UMLRTProtocolImpl::getRTMessageSet).filter(set -> set.getRtMsgKind() == kind).findFirst().map(RTMessageSet::getBase_Interface);
    }

    Interface requireMessageSet(RTMessageKind kind) {
        return this.getMessageSet(kind).orElseThrow(() -> new IllegalArgumentException("no such message set: " + kind));
    }

    static Interface requireMessageSet(Collaboration protocol, RTMessageKind kind) {
        return UMLRTProtocolImpl.getInstance(protocol).getMessageSet(kind).orElseThrow(() -> new IllegalArgumentException("no such message set: " + kind));
    }

    @Override
    public boolean isConjugate() {
        return this.isConjugate;
    }

    @Override
    public UMLRTProtocol getConjugate() {
        return this.conjugate.get();
    }

    @Override
    public UMLRTPackage getPackage() {
        Package protocolContainer = this.toUML().getNearestPackage();
        return protocolContainer == null ? null : UMLRTPackage.getInstance(protocolContainer.getNestingPackage());
    }

    @Override
    public Collaboration toUML() {
        return (Collaboration)super.toUML();
    }

    @Override
    public AnyReceiveEvent getAnyReceiveEvent() {
        AnyReceiveEvent result = null;
        Package protocolContainer = this.toUML().getNearestPackage();
        if (protocolContainer != null) {
            result = (AnyReceiveEvent)protocolContainer.getPackagedElement(ANY_RECEIVE_EVENT_NAME, false, UMLPackage.Literals.ANY_RECEIVE_EVENT, false);
        }
        return result;
    }

    @Override
    public List<UMLRTProtocol> getAncestry() {
        return this.doGetAncestry();
    }

    private List<UMLRTProtocol> doGetAncestry() {
        return (List)UMLRTProtocolImpl.ancestry(this.toUML(), Collaboration.class).stream().map(UMLRTProtocolImpl::getInstance).filter(Objects::nonNull).map(this::forConjugation).collect(Collectors.collectingAndThen(Collectors.toList(), ECollections::unmodifiableEList));
    }

    @Override
    public List<UMLRTProtocolMessage> getMessages(RTMessageKind kind) {
        switch (kind) {
            case IN: {
                return this.getInMessages();
            }
            case OUT: {
                return this.getOutMessages();
            }
            case IN_OUT: {
                return this.getInOutMessages();
            }
        }
        throw new IllegalArgumentException(kind.getName());
    }

    UnaryOperator<UMLRTProtocolMessage> messageConjugation() {
        return this.isConjugate() ? UMLRTProtocolMessage::getConjugate : UnaryOperator.identity();
    }

    private RTMessageKind forConjugation(RTMessageKind kind) {
        if (kind != null && this.isConjugate()) {
            switch (kind) {
                case IN: {
                    kind = RTMessageKind.OUT;
                    break;
                }
                case OUT: {
                    kind = RTMessageKind.IN;
                    break;
                }
            }
        }
        return kind;
    }

    @Override
    public List<UMLRTProtocolMessage> getMessages(RTMessageKind kind, boolean withExclusions) {
        return this.getFacades(MESSAGE_REFERENCES.get(this.forConjugation(kind)), withExclusions, this.messageConjugation());
    }

    @Override
    public List<UMLRTProtocolMessage> getMessages(boolean withExclusions) {
        return MESSAGE_REFERENCES.values().stream().flatMap(ref -> ref.facades((Element)this.toUML(), withExclusions)).map(this.messageConjugation()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public UMLRTProtocolMessage createMessage(RTMessageKind kind, String name) {
        UMLRTProtocolMessageImpl result = (UMLRTProtocolMessageImpl)this.create(MESSAGE_REFERENCES.get(this.forConjugation(kind)), name);
        result.initReceiveEvent();
        return (UMLRTProtocolMessage)this.messageConjugation().apply(result);
    }

    @Override
    public UMLRTProtocolMessage createMessage(RTMessageKind kind, String name, Type dataType) {
        UMLRTProtocolMessage result = this.createMessage(kind, name);
        result.toUML().createOwnedParameter("data", dataType);
        return result;
    }

    @Override
    public UMLRTProtocolMessage createMessage(RTMessageKind kind, String name, List<String> parameterName, List<Type> parameterType) {
        UMLRTProtocolMessage result = this.createMessage(kind, name);
        if (parameterName != null && parameterType != null) {
            int count = parameterName.size();
            if (parameterType.size() != count) {
                throw new IllegalArgumentException("parameter names and types mismatched");
            }
            int i = 0;
            while (i < count) {
                result.toUML().createOwnedParameter(parameterName.get(i), parameterType.get(i));
                ++i;
            }
        }
        return result;
    }

    @Override
    public Stream<UMLRTProtocol> getHierarchy() {
        return UMLRTProtocolImpl.hierarchy(this.toUML(), Collaboration.class).map(UMLRTProtocol::getInstance).filter(Objects::nonNull).map(this::forConjugation);
    }

    @Override
    protected Stream<? extends UMLRTNamedElement> excludedElements() {
        Stream<Object> result = Stream.empty();
        Collaboration uml = this.toUML();
        if (uml instanceof InternalUMLRTElement) {
            result = this.messageSets().flatMap(set -> {
                List exclusions = (List)set.eGet((EStructuralFeature)ExtUMLExtPackage.Literals.NAMESPACE__EXCLUDED_MEMBER);
                return exclusions.stream().map(UMLRTFactory::create).filter(Objects::nonNull);
            });
        }
        return result;
    }

    UMLRTProtocol initContents() {
        this.createMessageSet(RTMessageKind.IN);
        this.createMessageSet(RTMessageKind.OUT);
        this.createMessageSet(RTMessageKind.IN_OUT);
        this.toUML().getNearestPackage().createPackagedElement(ANY_RECEIVE_EVENT_NAME, UMLPackage.Literals.ANY_RECEIVE_EVENT);
        return this;
    }

    private void createMessageSet(RTMessageKind direction) {
        Package protocolContainer = this.toUML().getNearestPackage();
        String name = this.getName();
        switch (direction) {
            case OUT: {
                name = String.valueOf(name) + "~";
                break;
            }
            case IN_OUT: {
                name = String.valueOf(name) + "IO";
                break;
            }
        }
        Interface messageSet = (Interface)protocolContainer.createOwnedType(name, UMLPackage.Literals.INTERFACE);
        RTMessageSet stereo = (RTMessageSet)UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)messageSet).applyStereotype((Element)messageSet, UMLRealTimePackage.Literals.RT_MESSAGE_SET);
        stereo.setRtMsgKind(direction);
        switch (direction) {
            case IN: {
                this.toUML().createInterfaceRealization(null, messageSet);
                break;
            }
            case OUT: {
                this.toUML().createUsage((NamedElement)messageSet);
                break;
            }
            case IN_OUT: {
                this.toUML().createInterfaceRealization(null, messageSet);
                this.toUML().createUsage((NamedElement)messageSet);
            }
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getMessages();
            }
            case 16: {
                return this.getPackage();
            }
            case 17: {
                return this.getSuperProtocol();
            }
            case 18: {
                return this.getSubProtocols();
            }
            case 20: {
                return this.getInMessages();
            }
            case 21: {
                return this.getOutMessages();
            }
            case 22: {
                return this.getInOutMessages();
            }
            case 23: {
                return this.isConjugate();
            }
            case 24: {
                return this.getConjugate();
            }
            case 25: {
                return this.getHierarchy();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        switch (referenceID) {
            case 19: {
                return new FacadeObjectEList(this, UMLRTProtocolMessage.class, referenceID, MESSAGE_REFERENCES.values().stream().flatMap(r -> r.facades((Element)this.toUML(), true)).collect(Collectors.toList()));
            }
            case 20: {
                return this.getFacades(MESSAGE_REFERENCES.get(RTMessageKind.IN), true);
            }
            case 21: {
                return this.getFacades(MESSAGE_REFERENCES.get(RTMessageKind.OUT), true);
            }
            case 22: {
                return this.getFacades(MESSAGE_REFERENCES.get(RTMessageKind.IN_OUT), true);
            }
            case 10: {
                return new FacadeContentsEList((InternalFacadeObject)this, true, REDEFINABLE_ELEMENT_ESUBSETS);
            }
        }
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.setSuperProtocol((UMLRTProtocol)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.setSuperProtocol(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 14: {
                return this.isSetGeneral();
            }
            case 15: {
                return this.isSetSpecifics();
            }
            case 19: {
                return this.isSetMessages();
            }
            case 10: {
                return this.isSetRedefinableElements();
            }
            case 16: {
                return this.getPackage() != null;
            }
            case 17: {
                return this.getSuperProtocol() != null;
            }
            case 18: {
                return !this.getSubProtocols().isEmpty();
            }
            case 20: {
                return !this.getInMessages().isEmpty();
            }
            case 21: {
                return !this.getOutMessages().isEmpty();
            }
            case 22: {
                return !this.getInOutMessages().isEmpty();
            }
            case 23: {
                return this.isConjugate();
            }
            case 24: {
                return this.getConjugate() != null;
            }
            case 25: {
                return this.getHierarchy() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetGeneral() {
        return super.isSetGeneral() || this.eIsSet(17);
    }

    @Override
    public boolean isSetSpecifics() {
        return super.isSetSpecifics() || this.eIsSet(18);
    }

    public boolean isSetMessages() {
        return this.eIsSet(20) || this.eIsSet(21) || this.eIsSet(22);
    }

    @Override
    public boolean isSetRedefinableElements() {
        return super.isSetRedefinableElements() || this.isSetMessages();
    }

    protected static class ProtocolAdapter<F extends UMLRTProtocolImpl>
    extends UMLRTClassifierImpl.ClassifierAdapter<F> {
        private final Supplier<ProtocolAdapter<F>> conjugate;

        ProtocolAdapter(F facade) {
            super(facade);
            this.conjugate = new CachedReference<ProtocolAdapter>(() -> {
                UMLRTProtocol conj;
                Supplier conjugateSupplier;
                ProtocolAdapter<UMLRTProtocolImpl> result = null;
                UMLRTProtocolImpl base = (UMLRTProtocolImpl)this.get();
                if (base != null && (!((conjugateSupplier = base.conjugate) instanceof CachedReference) || ((CachedReference)conjugateSupplier).exists()) && (conj = (UMLRTProtocol)conjugateSupplier.get()) != null) {
                    UMLRTProtocolImpl conjAsF = (UMLRTProtocolImpl)conj;
                    result = new ProtocolAdapter<UMLRTProtocolImpl>(conjAsF, null);
                }
                return result;
            });
        }

        private ProtocolAdapter(F facade, Supplier<ProtocolAdapter<F>> conjugate) {
            super(facade);
            this.conjugate = conjugate;
        }

        protected final boolean isConjugate() {
            return this.conjugate == null;
        }

        @Override
        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            if (newTarget instanceof Collaboration) {
                Collaboration protocol = (Collaboration)newTarget;
                Package container = protocol.getNearestPackage();
                if (container != null) {
                    this.addAdapter((Notifier)container);
                }
            } else if (newTarget instanceof Package) {
                Package container = (Package)newTarget;
                container.getOwnedTypes().stream().filter(Interface.class::isInstance).map(Interface.class::cast).filter(UMLRTProtocolImpl::isRTMessageSet).forEach(this::addAdapter);
            }
        }

        @Override
        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof Collaboration) {
                Collaboration protocol = (Collaboration)oldTarget;
                Package container = protocol.getNearestPackage();
                if (container != null) {
                    this.removeAdapter((Notifier)container);
                }
            } else if (oldTarget instanceof Package) {
                Package container = (Package)oldTarget;
                container.getOwnedTypes().stream().filter(Interface.class::isInstance).forEach(this::removeAdapter);
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void handleReference(Notification msg) {
            ProtocolAdapter<F> conjugate;
            super.handleReference(msg);
            if (msg.getFeature() == UMLPackage.Literals.INTERFACE__OWNED_OPERATION && !this.isConjugate() && (conjugate = this.conjugate.get()) != null) {
                conjugate.handleReference(msg);
            }
        }

        @Override
        protected FacadeObject getFacade(EObject owner, EReference reference, EObject object) {
            FacadeObject result = super.getFacade(owner, reference, object);
            if (result instanceof UMLRTProtocolMessage && this.isConjugate()) {
                result = ((UMLRTProtocolMessage)result).getConjugate();
            } else if (result instanceof UMLRTProtocol && this.isConjugate()) {
                result = ((UMLRTProtocol)result).getConjugate();
            }
            return result;
        }

        @Override
        protected void notifyGeneral(F owner, FacadeObject oldObject, FacadeObject newObject) {
            if (owner.eNotificationRequired()) {
                owner.eNotify((Notification)new ENotificationImpl(owner, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.PROTOCOL__SUPER_PROTOCOL, (Object)oldObject, (Object)newObject));
            }
            super.notifyGeneral(owner, oldObject, newObject);
        }

        @Override
        protected List<? extends FacadeObject> getFacadeList(EObject owner, EReference reference, EObject object) {
            InternalFacadeEList<UMLRTProtocolMessage> result;
            if (reference == UMLPackage.Literals.INTERFACE__OWNED_OPERATION || reference == ExtUMLExtPackage.Literals.INTERFACE__IMPLICIT_OPERATION) {
                Element interface_ = UMLRTExtensionUtil.getUMLElement(owner);
                RTMessageSet stereo = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)interface_, RTMessageSet.class);
                if (stereo != null) {
                    switch (stereo.getRtMsgKind()) {
                        case IN: {
                            result = this.isConjugate() ? ((UMLRTProtocolImpl)this.get()).outMessages : ((UMLRTProtocolImpl)this.get()).inMessages;
                            break;
                        }
                        case OUT: {
                            result = this.isConjugate() ? ((UMLRTProtocolImpl)this.get()).inMessages : ((UMLRTProtocolImpl)this.get()).outMessages;
                            break;
                        }
                        case IN_OUT: {
                            result = ((UMLRTProtocolImpl)this.get()).inOutMessages;
                            break;
                        }
                        default: {
                            result = null;
                            break;
                        }
                    }
                } else {
                    result = null;
                }
            } else {
                result = super.getFacadeList(owner, reference, object);
            }
            return result;
        }

        @Override
        protected void handleObjectAdded(Notification msg, int position, EObject object) {
            if (msg.getFeature() == UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT) {
                if (object instanceof Interface) {
                    this.addAdapter((Notifier)object);
                }
            } else {
                super.handleObjectAdded(msg, position, object);
            }
        }

        @Override
        protected void handleObjectAdded(Notification msg, int position, FacadeObject object) {
            super.handleObjectAdded(msg, position, object);
            if (object instanceof UMLRTProtocolMessageImpl) {
                ((UMLRTProtocolMessageImpl)object).kindChanged();
            }
        }

        @Override
        protected void handleObjectRemoved(Notification msg, int position, EObject object) {
            if (msg.getFeature() == UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT) {
                if (object instanceof Interface) {
                    this.removeAdapter((Notifier)object);
                }
            } else {
                super.handleObjectRemoved(msg, position, object);
            }
        }

        @Override
        protected InternalFacadeEList<? extends FacadeObject> validateObject(EObject owner, EReference reference, FacadeObject object) {
            InternalFacadeEList<FacadeObject> result = null;
            if (object instanceof UMLRTProtocolMessage && (reference == UMLPackage.Literals.INTERFACE__OWNED_OPERATION || reference == ExtUMLExtPackage.Literals.INTERFACE__IMPLICIT_OPERATION)) {
                Element interface_ = UMLRTExtensionUtil.getUMLElement(owner);
                RTMessageSet messageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)interface_, RTMessageSet.class);
                if (messageSet != null) {
                    switch (messageSet.getRtMsgKind()) {
                        case IN: {
                            result = this.isConjugate() ? ((UMLRTProtocolImpl)this.get()).outMessages : ((UMLRTProtocolImpl)this.get()).inMessages;
                            break;
                        }
                        case OUT: {
                            result = this.isConjugate() ? ((UMLRTProtocolImpl)this.get()).inMessages : ((UMLRTProtocolImpl)this.get()).outMessages;
                            break;
                        }
                        case IN_OUT: {
                            result = ((UMLRTProtocolImpl)this.get()).inOutMessages;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                result = super.validateObject(owner, reference, object);
            }
            return result;
        }

        @Override
        public void tickle(NamedElement element) {
            if (element instanceof Interface) {
                this.discover((EObject)element, UMLPackage.Literals.INTERFACE__OWNED_OPERATION);
            } else {
                super.tickle(element);
            }
        }
    }
}

