/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.VertexOperations;

public class VertexRTOperations
extends VertexOperations {
    protected VertexRTOperations() {
    }

    public static EList<Transition> getIncomings(Vertex vertex) {
        UniqueEList.FastCompare result = new UniqueEList.FastCompare();
        StateMachine machine = VertexRTOperations.containingStateMachine(vertex);
        if (machine != null) {
            Iterator<Transition> iter = VertexRTOperations.allTransitions(machine);
            while (iter.hasNext()) {
                Transition next = iter.next();
                if (UMLRTExtensionUtil.isExcluded((Element)next) || next.getTarget() != vertex) continue;
                result.add((Object)next);
            }
        }
        return new IncomingRTEList((InternalUMLRTElement)vertex, (EStructuralFeature)UMLPackage.Literals.VERTEX__INCOMING, (EList<Transition>)result);
    }

    public static StateMachine containingStateMachine(Vertex vertex) {
        State state;
        StateMachine result = vertex.containingStateMachine();
        if (result == null && vertex instanceof Pseudostate && (state = ((Pseudostate)vertex).getState()) != null) {
            result = state.containingStateMachine();
        }
        return result;
    }

    public static EList<Transition> getOutgoings(Vertex vertex) {
        UniqueEList.FastCompare result = new UniqueEList.FastCompare();
        StateMachine machine = VertexRTOperations.containingStateMachine(vertex);
        if (machine != null) {
            Iterator<Transition> iter = VertexRTOperations.allTransitions(machine);
            while (iter.hasNext()) {
                Transition next = iter.next();
                if (UMLRTExtensionUtil.isExcluded((Element)next) || next.getSource() != vertex) continue;
                result.add((Object)next);
            }
        }
        return new OutgoingRTEList((InternalUMLRTElement)vertex, (EStructuralFeature)UMLPackage.Literals.VERTEX__OUTGOING, (EList<Transition>)result);
    }

    protected static Iterator<Transition> allTransitions(StateMachine stateMachine) {
        AbstractTreeIterator<EObject> tree = new AbstractTreeIterator<EObject>((Object)stateMachine, false){

            protected Iterator<? extends EObject> getChildren(Object object) {
                Iterator result = object instanceof Region ? this.contents((EObject)((Region)object), UMLPackage.Literals.REGION__TRANSITION, UMLPackage.Literals.REGION__SUBVERTEX) : (object instanceof State ? this.contents((EObject)((State)object), UMLPackage.Literals.STATE__REGION, new EReference[0]) : (object instanceof StateMachine ? this.contents((EObject)((StateMachine)object), UMLPackage.Literals.STATE_MACHINE__REGION, new EReference[0]) : Collections.emptyIterator()));
                return result;
            }

            private Iterator<? extends EObject> contents(EObject object, EReference reference, EReference ... rest) {
                return UMLRTExtensionUtil.getUMLRTContents(object, (EStructuralFeature)reference, (EStructuralFeature[])rest).iterator();
            }
        };
        return new Iterator<Transition>((TreeIterator)tree){
            boolean done;
            Transition prepared;
            private final /* synthetic */ TreeIterator val$tree;
            {
                this.val$tree = treeIterator;
            }

            @Override
            public boolean hasNext() {
                while (this.prepared == null) {
                    if (!this.val$tree.hasNext()) {
                        this.done = true;
                        break;
                    }
                    Object next = this.val$tree.next();
                    if (next instanceof Transition) {
                        this.prepared = (Transition)next;
                        continue;
                    }
                    if (next instanceof Pseudostate) {
                        this.val$tree.prune();
                        continue;
                    }
                    if (!(next instanceof State) || ((State)next).isComposite()) continue;
                    this.val$tree.prune();
                }
                return !this.done;
            }

            @Override
            public Transition next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Transition result = this.prepared;
                this.prepared = null;
                return result;
            }
        };
    }

    protected static class IncomingRTEList
    extends VertexOperations.IncomingEList {
        private static final long serialVersionUID = 1L;

        protected IncomingRTEList(InternalUMLRTElement owner, EStructuralFeature eStructuralFeature, EList<Transition> delegateList) {
            super((InternalEObject)owner, eStructuralFeature, delegateList);
        }
    }

    protected static class OutgoingRTEList
    extends VertexOperations.OutgoingEList {
        private static final long serialVersionUID = 1L;

        protected OutgoingRTEList(InternalUMLRTElement owner, EStructuralFeature eStructuralFeature, EList<Transition> delegateList) {
            super((InternalEObject)owner, eStructuralFeature, delegateList);
        }
    }
}

