/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;

public final class CachedReference<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private Supplier<T> reference;

    public CachedReference(Supplier<T> supplier) {
        this.supplier = supplier;
        this.reference = this::compute;
    }

    private T compute() {
        T result = this.supplier.get();
        this.reference = new SoftReference<T>(result)::get;
        return result;
    }

    @Override
    public T get() {
        T result = this.reference.get();
        if (result == null) {
            result = this.compute();
        }
        return result;
    }

    public boolean exists() {
        return this.reference != null && this.reference.get() != null;
    }
}

