/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.operations.RedefinableElementRTOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InheritableEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.RTNotificationImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;

public class InheritableEcoreEList<E>
extends DelegatingEcoreEList<E>
implements InheritableEList<E>,
Adapter {
    private static final long serialVersionUID = 1L;
    private static final int SET_EFLAG = 1;
    private static final int HANDLING_INHERITANCE_EFLAG = 2;
    private static final int FEATURE_EOFFSET = 2;
    private final EList<E> content = new BasicEList();
    private EList<E> inherited;
    private int eFlags;

    public InheritableEcoreEList(InternalEObject owner, int featureID) {
        super(owner);
        this.eFlags = featureID << 2;
    }

    public int getFeatureID() {
        return this.eFlags >> 2;
    }

    @Override
    public boolean isSet() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public void unset() {
        int wasSet = this.isSet() ? 1 : 0;
        this.eFlags &= 0xFFFFFFFE;
        ArrayList<E> oldElements = new ArrayList<E>(this.delegateList());
        EList result = (EList)RedefinableElementRTOperations.inheritFeature((InternalUMLRTElement)this.getEObject(), (EStructuralFeature)this.getFeature());
        try {
            if (result == null || wasSet != 0 && !this.isContainment()) {
                this.eFlags |= wasSet;
                if (result == null) {
                    this.clear();
                } else {
                    ECollections.setEList((EList)this, (List)result);
                }
                this.eFlags &= 0xFFFFFFFE;
            }
            if (result != null && result != this) {
                this.inherit(result, true);
            }
        }
        finally {
            this.eFlags &= 0xFFFFFFFE;
        }
        oldElements.stream().filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast).forEach(InternalUMLRTElement::rtAdjustStereotypes);
    }

    @Override
    public void touch() {
        InternalUMLRTElement rtOwner;
        this.eFlags |= 1;
        if (this.inherited != null) {
            this.unadapt(this.inherited);
            this.inherited = null;
        }
        if (this.owner instanceof InternalUMLRTElement && (rtOwner = (InternalUMLRTElement)this.owner).rtIsVirtual()) {
            rtOwner.rtReify();
        }
        this.stream().filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast).forEach(InternalUMLRTElement::rtAdjustStereotypes);
    }

    protected List<E> delegateList() {
        return this.content;
    }

    protected final void handlingInheritance(Runnable action) {
        int restore = this.eFlags | 0xFFFFFFFD;
        this.eFlags |= 2;
        try {
            if (this.getNotifier() instanceof InternalUMLRTElement) {
                ((InternalUMLRTElement)this.getNotifier()).run(action);
            } else {
                action.run();
            }
        }
        finally {
            this.eFlags &= restore;
        }
    }

    @Override
    public void inherit(EList<E> newInherited) {
        this.inherit(newInherited, false);
    }

    protected void inherit(EList<E> newInherited, boolean isUnset) {
        NotificationChain msgs;
        if (this.canInherit() && (msgs = this.basicInherit(newInherited, isUnset, null)) != null && this.owner.eNotificationRequired()) {
            msgs.dispatch();
        }
    }

    protected NotificationChain basicInherit(EList<E> newInherited, boolean isUnset, NotificationChain msgs) {
        NotificationChain[] result = new NotificationChain[]{msgs};
        if (this.inherited != newInherited) {
            this.handlingInheritance(() -> {
                if (this.inherited != null) {
                    this.unadapt(this.inherited);
                }
                this.inherited = newInherited;
                if (this.inherited != null) {
                    this.adapt(this.inherited);
                }
                if (this.inherited == null || this.inherited.isEmpty()) {
                    if (isUnset && !this.isEmpty()) {
                        this.clear();
                    }
                } else {
                    List<E> redefinitions = this.redefineMany((List<E>)this.inherited);
                    notificationChainArray[0] = this.setInherited(redefinitions, result[0]);
                    redefinitions.forEach(this::redefined);
                }
            });
        }
        return result[0];
    }

    protected NotificationChain setInherited(List<E> elements, NotificationChain msgs) {
        if (!this.isEmpty()) {
            this.doClear();
        }
        this.doAddAllUnique(elements);
        return msgs;
    }

    final boolean canInherit() {
        return (this.eFlags & 3) == 0;
    }

    protected void disinherit() {
        if (this.canInherit()) {
            NotificationChain msgs = this.basicInherit(null, false, null);
            this.touch();
            if (msgs != null && this.owner.eNotificationRequired()) {
                msgs.dispatch();
            }
        }
    }

    protected E redefineSingle(E inherited) {
        return inherited;
    }

    protected List<E> redefineMany(List<E> inherited) {
        return inherited;
    }

    protected void redefined(E element) {
    }

    protected void unredefined(E element) {
    }

    protected E delegateSet(int index, E object) {
        this.disinherit();
        return (E)super.delegateSet(index, object);
    }

    protected void delegateAdd(E object) {
        this.disinherit();
        super.delegateAdd(object);
    }

    protected void delegateAdd(int index, E object) {
        boolean canInherit = this.canInherit();
        this.disinherit();
        if (canInherit && ReificationAdapter.isUndoRedoInProgress((Notifier)this.owner)) {
            this.delegateBasicList().clear();
        }
        super.delegateAdd(index, object);
    }

    protected E delegateRemove(int index) {
        this.disinherit();
        return (E)super.delegateRemove(index);
    }

    protected void delegateClear() {
        this.disinherit();
        super.delegateClear();
    }

    protected E delegateMove(int targetIndex, int sourceIndex) {
        this.disinherit();
        return (E)super.delegateMove(targetIndex, sourceIndex);
    }

    protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
        return new RTNotificationImpl(this.owner, eventType, this.getFeatureID(), oldObject, newObject, index, wasSet);
    }

    static EObject getOwner(EList<?> list) {
        return list instanceof EStructuralFeature.Setting ? ((EStructuralFeature.Setting)list).getEObject() : null;
    }

    private void adapt(EList<?> inherited) {
        EObject owner = InheritableEcoreEList.getOwner(inherited);
        if (owner != null && !owner.eAdapters().contains((Object)this)) {
            owner.eAdapters().add((Object)this);
        }
    }

    private void unadapt(EList<?> inherited) {
        EObject owner = InheritableEcoreEList.getOwner(inherited);
        if (owner != null) {
            owner.eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.isTouch() || notification.getFeature() != this.getFeature() || NotificationForwarder.isForwarded(notification)) {
            return;
        }
        this.handlingInheritance(() -> {
            switch (notification.getEventType()) {
                case 3: {
                    int position = notification.getPosition();
                    Object added = notification.getNewValue();
                    Object redefinition = this.redefineSingle(added);
                    this.add(position, redefinition);
                    this.redefined(redefinition);
                    break;
                }
                case 4: {
                    int position = notification.getPosition();
                    Object redefinition = this.remove(position);
                    this.unredefined(redefinition);
                    break;
                }
                case 5: {
                    int position = notification.getPosition();
                    List added = (List)notification.getNewValue();
                    List<E> redefinitions = this.redefineMany(added);
                    this.addAll(position, redefinitions);
                    redefinitions.forEach(this::redefined);
                    break;
                }
                case 6: {
                    if (notification.getPosition() == -1) {
                        this.clear();
                        break;
                    }
                    int[] positions = (int[])notification.getNewValue();
                    List<Object> redefinitions = IntStream.of(positions).mapToObj(arg_0 -> ((InheritableEcoreEList)this).get(arg_0)).collect(Collectors.toList());
                    this.removeAll(redefinitions);
                    redefinitions.forEach(this::unredefined);
                    break;
                }
                case 1: {
                    int position = notification.getPosition();
                    Object added = notification.getNewValue();
                    Object newRedefinition = this.redefineSingle(added);
                    Object oldRedefinition = this.set(position, newRedefinition);
                    this.unredefined(oldRedefinition);
                    this.redefined(newRedefinition);
                }
            }
        });
    }

    public Notifier getTarget() {
        return InheritableEcoreEList.getOwner(this.inherited);
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type == this;
    }
}

