/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.operations.RedefinableElementRTOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InheritableSetting;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.RTNotificationImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;
import org.eclipse.uml2.uml.RedefinableElement;

public abstract class InheritableSingleContainment<E extends EObject>
extends AdapterImpl
implements InheritableSetting<E>,
Adapter {
    private static final int SET_EFLAG = 1;
    private static final int HANDLING_INHERITANCE_EFLAG = 2;
    private static final int FEATURE_EOFFSET = 2;
    private E inherited;
    private int eFlags;

    public InheritableSingleContainment(int featureID) {
        this.eFlags = featureID << 2;
    }

    public InternalUMLRTElement getEObject() {
        return (InternalUMLRTElement)this.getTarget();
    }

    public int getFeatureID() {
        return this.eFlags >> 2;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.getEObject().eClass().getEStructuralFeature(this.getFeatureID());
    }

    @Override
    public E getInheritable() {
        E result = this.get();
        EObject inheritedResult = (EObject)this.getEObject().inheritFeature(this.getEStructuralFeature());
        if (inheritedResult != result) {
            this.inherit((E)inheritedResult);
            result = this.get();
        }
        return result;
    }

    protected E get() {
        EObject result = (EObject)this.get(false);
        return (E)result;
    }

    public boolean isSet() {
        return (this.eFlags & 1) != 0;
    }

    public void unset() {
        boolean wasSet = this.isSet();
        E oldValue = this.getInheritable();
        InternalUMLRTElement owner = this.getEObject();
        this.eFlags &= 0xFFFFFFFE;
        EObject result = (EObject)RedefinableElementRTOperations.inheritFeature(this.getEObject(), this.getEStructuralFeature());
        if (this.inherited == null) {
            this.inherited = oldValue;
        }
        this.basicInherit(result, true);
        E newValue = this.get();
        if (!ReificationAdapter.isUndoRedoInProgress((Notifier)owner) && newValue instanceof InternalUMLRTElement) {
            ((InternalUMLRTElement)newValue).rtUnsetAll();
        }
        if (owner.eNotificationRequired()) {
            owner.eNotify((Notification)new RTNotificationImpl((InternalEObject)owner, 2, this.getEStructuralFeature(), oldValue, newValue, wasSet));
        }
    }

    protected final void handlingInheritance(Runnable action) {
        int restore = this.eFlags | 0xFFFFFFFD;
        this.eFlags |= 2;
        try {
            InternalUMLRTElement owner = this.getEObject();
            if (owner instanceof InternalUMLRTElement) {
                owner.run(action);
            } else {
                action.run();
            }
        }
        finally {
            this.eFlags &= restore;
        }
    }

    @Override
    public void inherit(E newInherited) {
        this.basicInherit(newInherited, false);
    }

    protected void basicInherit(E newInherited, boolean isUnset) {
        if (this.inherited != newInherited) {
            this.handlingInheritance(() -> {
                InternalUMLRTElement owner = this.getEObject();
                E oldInherited = this.inherited;
                if (this.inherited != null) {
                    this.unadapt(this.inherited);
                }
                boolean canReuse = isUnset && oldInherited != newInherited && oldInherited instanceof InternalUMLRTElement;
                NotificationChain msgs = null;
                E oldValue = this.get();
                if (oldValue != null && !canReuse) {
                    NotificationForwarder.initialize(oldValue);
                    InternalEObject internalValue = (InternalEObject)oldValue;
                    InternalEObject oldOwner = internalValue.eInternalContainer();
                    int oldFeatureID = internalValue.eContainerFeatureID();
                    msgs = internalValue.eInverseRemove(oldOwner, oldFeatureID, null, msgs);
                }
                this.inherited = newInherited;
                if (this.inherited == null) {
                    msgs = this.basicSet(null, msgs);
                } else {
                    E redefinition;
                    this.adapt(this.inherited);
                    if (canReuse) {
                        if (!ReificationAdapter.isUndoRedoInProgress((Notifier)owner)) {
                            ((InternalUMLRTElement)oldInherited).rtUnsetAll();
                        }
                        redefinition = oldInherited;
                    } else {
                        redefinition = this.createRedefinition(this.inherited);
                    }
                    if (redefinition != oldInherited) {
                        EReference containment = (EReference)this.getEStructuralFeature();
                        if (containment.getEOpposite() != null) {
                            ((InternalEObject)redefinition).eInverseAdd((InternalEObject)owner, containment.getEOpposite().getFeatureID(), containment.getEOpposite().getEReferenceType().getInstanceClass(), null);
                        } else {
                            ((InternalEObject)redefinition).eInverseAdd((InternalEObject)owner, -1 - this.getFeatureID(), null, null);
                        }
                    }
                    this.basicSet(redefinition, null);
                    NotificationForwarder.initialize(redefinition);
                    if (owner.eNotificationRequired()) {
                        ENotificationImpl msg = oldValue == null ? new ENotificationImpl((InternalEObject)owner, 9, this.getEStructuralFeature(), redefinition, redefinition) : new ENotificationImpl((InternalEObject)owner, 1, this.getEStructuralFeature(), oldValue, redefinition);
                        if (msgs != null) {
                            msgs.add((Notification)msg);
                        } else {
                            msgs = msg;
                        }
                    }
                    if (msgs != null) {
                        msgs.dispatch();
                    }
                }
            });
        }
    }

    public void set(Object newValue) {
        int oppositeID;
        InternalUMLRTElement owner = this.getEObject();
        boolean wasSet = this.isSet();
        E oldValue = this.get();
        Object msgs = null;
        this.disinherit();
        EReference reference = (EReference)this.getEStructuralFeature();
        int n = oppositeID = reference.getEOpposite() != null ? reference.getEOpposite().getFeatureID() : -1 - this.getFeatureID();
        if (oldValue != null) {
            NotificationForwarder.initialize(oldValue);
            if (reference.isContainment()) {
                msgs = ((InternalEObject)oldValue).eInverseRemove((InternalEObject)owner, oppositeID, null, msgs);
            }
        }
        if (newValue != null) {
            Object inheritedValue;
            if (reference.isContainment()) {
                msgs = ((InternalEObject)newValue).eInverseAdd((InternalEObject)owner, oppositeID, null, msgs);
            }
            NotificationForwarder.initialize(newValue);
            Object redefined = owner.rtGetRedefinedElement();
            if (redefined != null && (inheritedValue = redefined.eGet((EStructuralFeature)reference)) instanceof RedefinableElement && inheritedValue instanceof InternalUMLRTElement && newValue instanceof InternalUMLRTElement && ((InternalUMLRTElement)inheritedValue).eClass().isInstance(newValue)) {
                ((InternalUMLRTElement)newValue).rtRedefine((InternalUMLRTElement)inheritedValue);
            }
        }
        EObject newValue_ = (EObject)newValue;
        msgs = this.basicSet((E)newValue_, (NotificationChain)msgs);
        if (owner.eNotificationRequired()) {
            RTNotificationImpl setMsg = new RTNotificationImpl((InternalEObject)owner, 1, this.getEStructuralFeature(), oldValue, newValue, wasSet);
            if (msgs == null) {
                msgs = setMsg;
            } else {
                msgs.add((Notification)setMsg);
            }
        }
        if (msgs != null) {
            msgs.dispatch();
        }
    }

    protected abstract NotificationChain basicSet(E var1, NotificationChain var2);

    protected void disinherit() {
        if ((this.eFlags & 3) == 0) {
            this.basicInherit(null, false);
            this.eFlags |= 1;
        }
    }

    protected E createRedefinition(E inherited) {
        return (E)this.getEObject().create(inherited.eClass());
    }

    private void adapt(E inherited) {
        EObject owner = inherited.eContainer();
        if (owner != null && !owner.eAdapters().contains((Object)this)) {
            owner.eAdapters().add((Object)this);
        }
    }

    private void unadapt(E inherited) {
        EObject owner = inherited.eContainer();
        if (owner != null && owner != this.getEObject()) {
            owner.eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.isTouch() || notification.getNotifier() == this.getTarget() || notification.getFeature() != this.getEStructuralFeature()) {
            return;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                EObject added = (EObject)notification.getNewValue();
                this.inherit((E)added);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        if (this.getTarget() == null || newTarget == null) {
            super.setTarget(newTarget);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == this.getClass();
    }
}

