/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.impl.UMLRTUMLPlugin;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util.ExtensionResource;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.util.ReificationListener;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLMetamodelUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class ReificationAdapter
extends EContentAdapter {
    private static final Object TYPE = new Object();
    private final Map<EReference, Boolean> redefinitionReferences = new ConcurrentHashMap<EReference, Boolean>();
    private final AtomicInteger doNotReify = new AtomicInteger();
    private final Map<NamedElement, Boolean> awaitingReification = new WeakHashMap<NamedElement, Boolean>();
    private final Map<NamedElement, Object> listeners = new HashMap<NamedElement, Object>();
    private BooleanSupplier undoRedoQuery;

    public ReificationAdapter() {
        this.setUndoRedoQuery(null);
    }

    public static final ReificationAdapter getInstance(Notifier notifier) {
        ExtensionResource extent;
        ReificationAdapter result = (ReificationAdapter)EcoreUtil.getExistingAdapter((Notifier)notifier, (Object)TYPE);
        if (result == null && notifier instanceof InternalUMLRTElement && (extent = ExtensionResource.getExtensionExtent((EObject)((InternalUMLRTElement)notifier))) != null) {
            result = extent.getReificationAdapter();
        }
        return result;
    }

    public static final ReificationAdapter getInstance(ResourceSet resourceSet) {
        ReificationAdapter result = (ReificationAdapter)EcoreUtil.getExistingAdapter((Notifier)resourceSet, (Object)TYPE);
        if (result == null) {
            result = new ReificationAdapter();
            result.addAdapter((Notifier)resourceSet);
        }
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == TYPE;
    }

    public void basicSetTarget(Notifier newTarget) {
    }

    public void notifyChanged(Notification msg) {
        if (NotificationForwarder.isForwarded(msg)) {
            return;
        }
        super.notifyChanged(msg);
        if (!msg.isTouch() && !this.isUndoRedoNotification(msg)) {
            if (msg.getNotifier() instanceof InternalUMLRTElement) {
                int eventType;
                InternalUMLRTElement element = (InternalUMLRTElement)msg.getNotifier();
                if (element.rtIsVirtual() && !this.isBaseElementReference(msg.getFeature()) && !NotificationForwarder.isForwarded(msg) && !this.isRedefinitionReference(msg.getFeature()) && (eventType = msg.getEventType()) >= 0 && eventType < 10 && this.doNotReify.get() <= 0) {
                    element.rtReify();
                }
            } else if (msg.getFeature() == ExtUMLExtPackage.Literals.ELEMENT__EXTENDED_ELEMENT) {
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        if (msg.getOldValue() instanceof InternalUMLRTElement) {
                            this.removeAdapter((Notifier)((EObject)msg.getOldValue()));
                        }
                        if (msg.getNewValue() == null) break;
                        this.addAdapter((Notifier)((EObject)msg.getNewValue()));
                    }
                }
            }
        }
    }

    protected void setTarget(EObject target) {
        ExtElement extension;
        super.setTarget(target);
        if (target instanceof ExtElement && (extension = (ExtElement)target).getExtendedElement() != null) {
            this.addAdapter((Notifier)extension.getExtendedElement());
        }
    }

    protected void unsetTarget(EObject target) {
        ExtElement extension;
        super.unsetTarget(target);
        if (target instanceof ExtElement && (extension = (ExtElement)target).getExtendedElement() != null) {
            this.removeAdapter((Notifier)extension.getExtendedElement());
        }
    }

    protected void removeAdapter(Notifier notifier, boolean checkContainer, boolean checkResource) {
        super.removeAdapter(notifier, checkContainer || notifier instanceof InternalUMLRTElement, checkResource);
    }

    protected void removeAdapter(Notifier notifier) {
        if (notifier instanceof ExtElement) {
            return;
        }
        super.removeAdapter(notifier);
    }

    protected void handleContainment(Notification notification) {
        block18: {
            block19: {
                EReference reference;
                Object notifier;
                block20: {
                    EReference reference2;
                    block17: {
                        notifier = notification.getNotifier();
                        if (!(notifier instanceof Resource)) break block17;
                        super.handleContainment(notification);
                        break block18;
                    }
                    if (!(notifier instanceof InternalEObject)) break block19;
                    if (!(((InternalEObject)notifier).eInternalResource() instanceof ExtensionResource)) break block20;
                    super.handleContainment(notification);
                    if (!(notifier instanceof ExtElement) || !UMLPackage.Literals.NAMED_ELEMENT.isSuperTypeOf((reference2 = (EReference)notification.getFeature()).getEReferenceType())) break block18;
                    switch (notification.getEventType()) {
                        case 3: {
                            this.notifyReification((NamedElement)notification.getNewValue(), false);
                            break;
                        }
                        case 5: {
                            Collection added = (Collection)notification.getNewValue();
                            added.stream().forEach(e -> this.notifyReification((NamedElement)e, false));
                            break;
                        }
                        case 4: {
                            this.awaitingReification.put((NamedElement)notification.getOldValue(), true);
                            break;
                        }
                        case 6: {
                            Collection removed = (Collection)notification.getOldValue();
                            removed.stream().forEach(e -> {
                                Boolean bl = this.awaitingReification.put((NamedElement)e, true);
                            });
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (notification.getOldValue() != null) {
                                this.awaitingReification.put((NamedElement)notification.getOldValue(), true);
                            }
                            if (notification.getNewValue() == null) break block18;
                            this.notifyReification((NamedElement)notification.getNewValue(), false);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block18;
                }
                if (!(notifier instanceof InternalUMLRTElement) || !UMLPackage.Literals.NAMED_ELEMENT.isSuperTypeOf((reference = (EReference)notification.getFeature()).getEReferenceType())) break block18;
                switch (notification.getEventType()) {
                    case 3: {
                        this.notifyReification((NamedElement)notification.getNewValue(), true);
                        break;
                    }
                    case 5: {
                        Collection added = (Collection)notification.getNewValue();
                        added.stream().forEach(e -> this.notifyReification((NamedElement)e, true));
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (notification.getNewValue() == null) break block18;
                        this.notifyReification((NamedElement)notification.getNewValue(), true);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block18;
            }
            super.handleContainment(notification);
        }
    }

    public void addAdapter(Notifier notifier) {
        if (!(notifier instanceof Resource) || notifier instanceof ExtensionResource) {
            ListIterator adapters = notifier.eAdapters().listIterator();
            boolean more = adapters.hasNext();
            while (more) {
                Adapter next = (Adapter)adapters.next();
                if (next == this) break;
                if (next instanceof ReificationAdapter) {
                    adapters.set(this);
                    break;
                }
                more = adapters.hasNext();
                if (more) continue;
                adapters.add(this);
                break;
            }
        }
    }

    private void notifyReification(NamedElement element, boolean reified) {
        UMLRTNamedElement facade;
        List<ReificationListener> listeners;
        if (reified) {
            this.removeAdapter((Notifier)element);
            if (this.awaitingReification.remove(element) == null) {
                return;
            }
        } else {
            this.addAdapter((Notifier)element);
        }
        if ((listeners = this.getListeners(element)) != null && !listeners.isEmpty() && (facade = UMLRTFactory.create(element)) != null) {
            listeners.forEach(l -> {
                try {
                    l.reificationStateChanged(facade, reified);
                }
                catch (Exception e) {
                    UMLRTUMLPlugin.INSTANCE.log(e);
                }
            });
        }
    }

    public void run(Runnable action) {
        this.disableAutoReification();
        try {
            action.run();
        }
        finally {
            this.enableAutoReification();
        }
    }

    public <V> V run(Callable<V> action) {
        V result;
        this.disableAutoReification();
        try {
            try {
                result = action.call();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        finally {
            this.enableAutoReification();
        }
        return result;
    }

    public void disableAutoReification() {
        this.doNotReify.incrementAndGet();
    }

    public void enableAutoReification() {
        this.doNotReify.decrementAndGet();
    }

    protected boolean isBaseElementReference(Object feature) {
        boolean result = false;
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            result = reference.getName() != null && reference.getName().startsWith("base_") && UMLPackage.Literals.ELEMENT.isSuperTypeOf(reference.getEReferenceType()) && !UMLPackage.Literals.ELEMENT.isSuperTypeOf(reference.getEContainingClass());
        }
        return result;
    }

    protected boolean isRedefinitionReference(Object feature) {
        boolean result = false;
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            result = this.redefinitionReferences.computeIfAbsent(reference, ref -> UMLMetamodelUtil.isSubsetOf(ref, UMLPackage.Literals.REDEFINABLE_ELEMENT__REDEFINED_ELEMENT));
        }
        return result;
    }

    public void addListener(NamedElement element, ReificationListener listener) {
        Object existing = this.listeners.get(element);
        if (existing == null) {
            this.listeners.put(element, listener);
        } else if (existing != listener) {
            if (existing instanceof List) {
                CopyOnWriteArrayList list = (CopyOnWriteArrayList)existing;
                list.addIfAbsent(listener);
            } else {
                CopyOnWriteArrayList<ReificationListener> list = new CopyOnWriteArrayList<ReificationListener>(new ReificationListener[]{(ReificationListener)existing, listener});
                this.listeners.put(element, list);
            }
        }
    }

    public void removeListener(NamedElement element, ReificationListener listener) {
        Object existing = this.listeners.get(element);
        if (existing != null) {
            if (existing == listener) {
                this.listeners.remove(element);
            } else if (existing instanceof List) {
                ((List)existing).remove(listener);
            }
        }
    }

    private List<ReificationListener> getListeners(NamedElement element) {
        Object result = this.listeners.get(element);
        return result == null ? null : (result instanceof List ? (List<ReificationListener>)result : Collections.singletonList((ReificationListener)result));
    }

    @Deprecated
    public final void setUndoRedoRecognizer(Predicate<? super Notification> undoRedoRecognizer) {
        this.setUndoRedoQuery(undoRedoRecognizer == null ? null : new LegacyUndoRedoQuery(undoRedoRecognizer));
    }

    public final void setUndoRedoQuery(BooleanSupplier isUndoRedo) {
        this.undoRedoQuery = isUndoRedo == null ? () -> false : isUndoRedo;
    }

    public boolean isUndoRedoNotification(Notification notification) {
        return this.undoRedoQuery instanceof LegacyUndoRedoQuery ? ((LegacyUndoRedoQuery)this.undoRedoQuery).test(notification) : this.undoRedoQuery.getAsBoolean();
    }

    public boolean isUndoRedoInProgress() {
        return this.undoRedoQuery.getAsBoolean();
    }

    public static boolean isUndoRedoInProgress(Notifier object) {
        ReificationAdapter adapter = ReificationAdapter.getInstance(object);
        return adapter != null && adapter.isUndoRedoInProgress();
    }

    private static final class LegacyUndoRedoQuery
    implements BooleanSupplier,
    Predicate<Notification> {
        private final Notification fakeNotification = new NotificationImpl(2, null, null);
        private final Predicate<? super Notification> undoRedoRecognizer;

        LegacyUndoRedoQuery(Predicate<? super Notification> undoRedoRecognizer) {
            this.undoRedoRecognizer = undoRedoRecognizer;
        }

        @Override
        public boolean getAsBoolean() {
            return this.test(this.fakeNotification);
        }

        @Override
        public boolean test(Notification notification) {
            return this.undoRedoRecognizer.test((Notification)notification);
        }
    }
}

