/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.util.Pair;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTExtensionUtil {
    private static Map<EStructuralFeature, EStructuralFeature> EXTENSIONS;

    static {
        HashMap<EStructuralFeature, EStructuralFeature> ext = new HashMap<EStructuralFeature, EStructuralFeature>();
        ext.put((EStructuralFeature)UMLPackage.Literals.ENCAPSULATED_CLASSIFIER__OWNED_PORT, (EStructuralFeature)ExtUMLExtPackage.Literals.ENCAPSULATED_CLASSIFIER__IMPLICIT_PORT);
        ext.put((EStructuralFeature)UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_ATTRIBUTE, (EStructuralFeature)ExtUMLExtPackage.Literals.STRUCTURED_CLASSIFIER__IMPLICIT_ATTRIBUTE);
        ext.put((EStructuralFeature)UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_CONNECTOR, (EStructuralFeature)ExtUMLExtPackage.Literals.STRUCTURED_CLASSIFIER__IMPLICIT_CONNECTOR);
        ext.put((EStructuralFeature)UMLPackage.Literals.CLASS__OWNED_OPERATION, (EStructuralFeature)ExtUMLExtPackage.Literals.CLASS__IMPLICIT_OPERATION);
        ext.put((EStructuralFeature)UMLPackage.Literals.INTERFACE__OWNED_OPERATION, (EStructuralFeature)ExtUMLExtPackage.Literals.INTERFACE__IMPLICIT_OPERATION);
        ext.put((EStructuralFeature)UMLPackage.Literals.STATE_MACHINE__REGION, (EStructuralFeature)ExtUMLExtPackage.Literals.STATE_MACHINE__IMPLICIT_REGION);
        ext.put((EStructuralFeature)UMLPackage.Literals.STATE_MACHINE__CONNECTION_POINT, (EStructuralFeature)ExtUMLExtPackage.Literals.STATE_MACHINE__IMPLICIT_CONNECTION_POINT);
        ext.put((EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature)ExtUMLExtPackage.Literals.STATE__IMPLICIT_REGION);
        ext.put((EStructuralFeature)UMLPackage.Literals.STATE__CONNECTION_POINT, (EStructuralFeature)ExtUMLExtPackage.Literals.STATE__IMPLICIT_CONNECTION_POINT);
        ext.put((EStructuralFeature)UMLPackage.Literals.REGION__SUBVERTEX, (EStructuralFeature)ExtUMLExtPackage.Literals.REGION__IMPLICIT_SUBVERTEX);
        ext.put((EStructuralFeature)UMLPackage.Literals.REGION__TRANSITION, (EStructuralFeature)ExtUMLExtPackage.Literals.REGION__IMPLICIT_TRANSITION);
        ext.put((EStructuralFeature)UMLPackage.Literals.NAMESPACE__OWNED_RULE, (EStructuralFeature)ExtUMLExtPackage.Literals.NAMESPACE__IMPLICIT_OWNED_RULE);
        ext.put((EStructuralFeature)UMLPackage.Literals.TRANSITION__TRIGGER, (EStructuralFeature)ExtUMLExtPackage.Literals.TRANSITION__IMPLICIT_TRIGGER);
        ext.put((EStructuralFeature)UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR, (EStructuralFeature)ExtUMLExtPackage.Literals.BEHAVIORED_CLASSIFIER__IMPLICIT_BEHAVIOR);
        EXTENSIONS = ext;
    }

    private UMLRTExtensionUtil() {
    }

    public static boolean hasUMLRTExtension(Element element) {
        return element instanceof InternalUMLRTElement;
    }

    public static EObject getUMLRTExtension(Element element) {
        return UMLRTExtensionUtil.hasUMLRTExtension(element) ? ((InternalUMLRTElement)element).rtExtension(ExtElement.class) : null;
    }

    public static Element getUMLElement(EObject object) {
        return object instanceof Element ? (Element)object : (object instanceof ExtElement ? ((ExtElement)object).getExtendedElement() : null);
    }

    public static boolean isVirtualElement(Element element) {
        return element instanceof InternalUMLRTElement && ((InternalUMLRTElement)element).rtIsVirtual();
    }

    public static boolean isRedefinition(Element element) {
        boolean result = false;
        if (element instanceof InternalUMLRTElement) {
            InternalUMLRTElement rt = (InternalUMLRTElement)element;
            result = rt.rtIsRedefinition() && !rt.rtIsExcluded() && !rt.rtIsVirtual();
        }
        return result;
    }

    public static boolean isExcluded(Element element) {
        return element instanceof InternalUMLRTElement && ((InternalUMLRTElement)element).rtIsExcluded();
    }

    public static boolean isInherited(Element element) {
        return element instanceof InternalUMLRTElement && ((InternalUMLRTElement)element).rtIsRedefinition();
    }

    public static <T extends Element> T getRedefinedElement(T element) {
        return (T)(UMLRTExtensionUtil.isInherited(element) ? (Element)((InternalUMLRTElement)element).rtGetRedefinedElement() : null);
    }

    public static void touch(Element element) {
        if (UMLRTExtensionUtil.isVirtualElement(element)) {
            ((InternalUMLRTElement)element).rtReify();
        }
    }

    public static boolean isVirtualElement(FacadeObject element) {
        return UMLRTExtensionUtil.isVirtualElement(element.toUML());
    }

    public static <T extends Element> T getRootDefinition(T element) {
        Object result = element;
        if (element instanceof InternalUMLRTElement) {
            InternalUMLRTElement rt = (InternalUMLRTElement)element;
            result = (Element)rt.rtGetRootDefinition();
        }
        return result;
    }

    public static <T extends Element> boolean redefines(T element, T redefined) {
        boolean result;
        boolean bl = result = element == redefined;
        if (!result && element instanceof InternalUMLRTElement && redefined instanceof InternalUMLRTElement) {
            InternalUMLRTElement rt = (InternalUMLRTElement)element;
            result = rt.rtRedefines((InternalUMLRTElement)redefined);
        }
        return result;
    }

    public static void run(Element element, Runnable action) {
        InternalUMLRTElement context = null;
        if (element instanceof InternalUMLRTElement) {
            context = (InternalUMLRTElement)element;
        }
        if (context == null) {
            action.run();
        } else {
            context.run(action);
        }
    }

    public static void run(FacadeObject element, Runnable action) {
        UMLRTExtensionUtil.run(element.toUML(), action);
    }

    public static EStructuralFeature getExtensionFeature(EStructuralFeature umlFeature) {
        return EXTENSIONS.get(umlFeature);
    }

    public static List<? extends EStructuralFeature> getUMLRTSupersetOf(EStructuralFeature umlFeature) {
        EStructuralFeature extension = UMLRTExtensionUtil.getExtensionFeature(umlFeature);
        return extension == null ? Collections.singletonList(umlFeature) : new Pair<EStructuralFeature>(umlFeature, extension);
    }

    public static <E> EContentsEList<E> getUMLRTContents(EObject owner, Collection<? extends EStructuralFeature> umlFeatures) {
        InheritanceContentsList result;
        if (owner instanceof InternalUMLRTElement) {
            List allFeatures = umlFeatures.stream().map(UMLRTExtensionUtil::getUMLRTSupersetOf).flatMap(Collection::stream).collect(Collectors.toList());
            result = new InheritanceContentsList(owner, allFeatures);
        } else {
            result = new InheritanceContentsList(owner, umlFeatures.toArray(new EStructuralFeature[umlFeatures.size()]));
        }
        return result;
    }

    public static <E> EContentsEList<E> getUMLRTContents(EObject owner, EStructuralFeature umlFeature, EStructuralFeature ... rest) {
        EContentsEList result;
        if (owner instanceof InternalUMLRTElement) {
            if (rest.length == 0) {
                result = new InheritanceContentsList(owner, UMLRTExtensionUtil.getUMLRTSupersetOf(umlFeature));
            } else {
                ArrayList<? extends EStructuralFeature> allFeatures = new ArrayList<EStructuralFeature>();
                allFeatures.addAll(UMLRTExtensionUtil.getUMLRTSupersetOf(umlFeature));
                Stream.of(rest).map(UMLRTExtensionUtil::getUMLRTSupersetOf).forEach(allFeatures::addAll);
                result = new InheritanceContentsList(owner, allFeatures);
            }
        } else if (rest.length == 0) {
            result = new EContentsEList(owner, new EStructuralFeature[]{umlFeature});
        } else {
            ArrayList<EStructuralFeature> allFeatures = new ArrayList<EStructuralFeature>(1 + rest.length);
            allFeatures.add(umlFeature);
            allFeatures.addAll(Arrays.asList(rest));
            result = new EContentsEList(owner, allFeatures);
        }
        return result;
    }

    public static boolean remove(EObject owner, EStructuralFeature umlFeature, Object value) {
        EStructuralFeature ext;
        boolean result = UMLRTExtensionUtil.doRemove(owner, umlFeature, value);
        if (!result && owner instanceof InternalUMLRTElement && (ext = UMLRTExtensionUtil.getExtensionFeature(umlFeature)) != null) {
            result = UMLRTExtensionUtil.doRemove(owner, ext, value);
        }
        return result;
    }

    private static boolean doRemove(EObject owner, EStructuralFeature feature, Object value) {
        boolean result = false;
        Object existing = owner.eGet(feature);
        if (existing == value) {
            owner.eSet(feature, null);
            result = true;
        } else if (existing instanceof Collection) {
            result = ((Collection)existing).remove(value);
        }
        return result;
    }

    protected static class InheritanceContentsList<E>
    extends EContentsEList<E> {
        public InheritanceContentsList(EObject eObject, List<? extends EStructuralFeature> eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected boolean useIsSet() {
            return false;
        }

        public int size() {
            int result = 0;
            if (this.eStructuralFeatures != null) {
                int i = 0;
                while (i < this.eStructuralFeatures.length) {
                    EStructuralFeature feature = this.eStructuralFeatures[i];
                    if (this.isIncluded(feature) && (!this.useIsSet() || this.eObject.eIsSet(feature))) {
                        Object value = this.eObject.eGet(feature, this.resolve());
                        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                            FeatureMap featureMap = (FeatureMap)value;
                            int j = 0;
                            int size = featureMap.size();
                            while (j < size) {
                                if (this.isIncludedEntry(featureMap.getEStructuralFeature(j)) && featureMap.getValue(j) != null) {
                                    ++result;
                                }
                                ++j;
                            }
                        } else if (feature.isMany()) {
                            result += ((Collection)value).size();
                        } else if (value != null) {
                            ++result;
                        }
                    }
                    ++i;
                }
            }
            return result;
        }

        public boolean isEmpty() {
            if (this.eStructuralFeatures != null) {
                int i = 0;
                while (i < this.eStructuralFeatures.length) {
                    EStructuralFeature feature = this.eStructuralFeatures[i];
                    if (this.isIncluded(feature) && (!this.useIsSet() || this.eObject.eIsSet(feature))) {
                        Object value = this.eObject.eGet(feature, this.resolve());
                        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                            FeatureMap featureMap = (FeatureMap)value;
                            int j = 0;
                            int size = featureMap.size();
                            while (j < size) {
                                if (this.isIncludedEntry(featureMap.getEStructuralFeature(j)) && featureMap.getValue(j) != null) {
                                    return false;
                                }
                                ++j;
                            }
                        } else if (feature.isMany() ? !((Collection)value).isEmpty() : value != null) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        protected final boolean resolve() {
            return true;
        }

        protected ListIterator<E> newResolvingListIterator() {
            return new EContentsEList.ResolvingFeatureIteratorImpl<E>(this.eObject, this.eStructuralFeatures){

                protected boolean useIsSet() {
                    return this.useIsSet();
                }
            };
        }

        protected ListIterator<E> newNonResolvingListIterator() {
            return new EContentsEList.FeatureIteratorImpl<E>(this.eObject, this.eStructuralFeatures){

                protected boolean useIsSet() {
                    return this.useIsSet();
                }
            };
        }
    }
}

