/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.eval;

import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.AExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.BinExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Op;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.UnaryExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Var;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.AExprEvaluatorException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Scope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.Name;
import org.eclipse.papyrusrt.xtumlrt.aexpr.printers.OpPrinter;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@ToString(singleLine=true)
@Data
public class UnrecognizedOperatorException
extends AExprEvaluatorException {
    private final Scope scope;
    @Extension
    private static OpPrinter opPrinter = new OpPrinter();

    @Override
    public String getMessage() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Unrecognized operator '");
        AExpr _expr = this.getExpr();
        String _op = this.op(_expr);
        _builder.append(_op, "");
        _builder.append("' found when attempting to evaluate variable '");
        AExpr _expr_1 = this.getExpr();
        Name _name = ((Var)_expr_1).getName();
        CharSequence _text = this.namePrinter.toText(_name);
        _builder.append((Object)_text, "");
        _builder.append("' in scope context ");
        Name _contextName = this.scope.contextName();
        CharSequence _text_1 = this.namePrinter.toText(_contextName);
        _builder.append((Object)_text_1, "");
        return _builder.toString();
    }

    public String op(AExpr expr) {
        String _xifexpression = null;
        if (expr instanceof UnaryExpr) {
            Op _op = ((UnaryExpr)expr).getOp();
            _xifexpression = opPrinter.opText(_op);
        } else {
            String _xifexpression_1 = null;
            if (expr instanceof BinExpr) {
                Op _op_1 = ((BinExpr)expr).getOp();
                _xifexpression_1 = opPrinter.opText(_op_1);
            } else {
                _xifexpression_1 = "<unrecognized expression type>";
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public UnrecognizedOperatorException(AExpr expr, Scope scope) {
        super(expr);
        this.scope = scope;
    }

    @Override
    @Pure
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        UnrecognizedOperatorException other = (UnrecognizedOperatorException)obj;
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().singleLine().toString();
        return result;
    }

    @Pure
    public Scope getScope() {
        return this.scope;
    }
}

