/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens;

import com.google.common.base.Objects;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Token;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@ToString(singleLine=true)
public class Delimiter
extends Token {
    public static final char LPAR_CHAR = '(';
    public static final char RPAR_CHAR = ')';
    private static final String LPAR_STR = "(";
    private static final String RPAR_STR = ")";
    private Kind kind;

    public Delimiter(int line, int column, String text) {
        super(line, column, text);
        Kind _kind;
        this.kind = _kind = this.getKind();
    }

    public Kind getKind() {
        Kind _xblockexpression = null;
        if (this.kind == null) {
            Kind _switchResult = null;
            String _text = this.getText();
            boolean _matched = false;
            if (Objects.equal((Object)_text, (Object)LPAR_STR)) {
                _matched = true;
                _switchResult = Kind.LPAR;
            }
            if (!_matched && Objects.equal((Object)_text, (Object)RPAR_STR)) {
                _matched = true;
                _switchResult = Kind.RPAR;
            }
            if (!_matched) {
                _switchResult = Kind.UNKNOWN;
            }
            this.kind = _switchResult;
        }
        _xblockexpression = this.kind;
        return _xblockexpression;
    }

    public static boolean isBracket(char c) {
        return c == '(' || c == ')';
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().singleLine().toString();
        return result;
    }

    public static enum Kind {
        UNKNOWN,
        LPAR,
        RPAR;

    }
}

