/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageSort implements Enumerator
{
    ASYNCH_SIGNAL(0, "asynchSignal", "ASYNCH_SIGNAL"),
    ASYNCH_CALL(1, "asynchCall", "ASYNCH_CALL"),
    SYNCH_CALL(2, "synchCall", "SYNCH_CALL"),
    REPLY(3, "reply", "REPLY"),
    CREATE_MESSAGE(4, "createMessage", "CREATE_MESSAGE"),
    DELETE_MESSAGE(5, "deleteMessage", "DELETE_MESSAGE");

    public static final int ASYNCH_SIGNAL_VALUE = 0;
    public static final int ASYNCH_CALL_VALUE = 1;
    public static final int SYNCH_CALL_VALUE = 2;
    public static final int REPLY_VALUE = 3;
    public static final int CREATE_MESSAGE_VALUE = 4;
    public static final int DELETE_MESSAGE_VALUE = 5;
    private static final MessageSort[] VALUES_ARRAY;
    public static final List<MessageSort> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageSort[]{ASYNCH_SIGNAL, ASYNCH_CALL, SYNCH_CALL, REPLY, CREATE_MESSAGE, DELETE_MESSAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageSort get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageSort result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageSort getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageSort result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageSort get(int value) {
        switch (value) {
            case 0: {
                return ASYNCH_SIGNAL;
            }
            case 1: {
                return ASYNCH_CALL;
            }
            case 2: {
                return SYNCH_CALL;
            }
            case 3: {
                return REPLY;
            }
            case 4: {
                return CREATE_MESSAGE;
            }
            case 5: {
                return DELETE_MESSAGE;
            }
        }
        return null;
    }

    private MessageSort(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

