/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.merger;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.diagram.internal.merge.CompareDiagramMerger;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTDiagramChange;

public class UMLRTDiagramChangeMerger
extends CompareDiagramMerger {
    public boolean isMergerFor(Diff target) {
        return target instanceof UMLRTDiagramChange;
    }

    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        Set dependencies = super.getDirectMergeDependencies(diff, mergeRightToLeft);
        dependencies.addAll(this.addRequiredAutoDiagramChanges(diff, mergeRightToLeft));
        return dependencies;
    }

    private Set<Diff> addRequiredAutoDiagramChanges(Diff diff, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> requiredAutoDiagramChanges = new LinkedHashSet<Diff>();
        if (diff instanceof UMLRTDiagramChange && !UMLRTDiagramChangeMerger.isAccepting((Diff)diff, (boolean)mergeRightToLeft)) {
            UMLRTDiagramChange change = (UMLRTDiagramChange)diff;
            for (Diff autoDiagramChange : Iterables.filter((Iterable)change.getRequires(), UMLRTCompareUtil.AUTO_DIAGRAM_CHANGE)) {
                if (Iterables.any((Iterable)autoDiagramChange.getRequiredBy(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), Predicates.not((Predicate)Predicates.equalTo((Object)change)), Predicates.instanceOf(UMLRTDiagramChange.class)}))) continue;
                requiredAutoDiagramChanges.add(autoDiagramChange);
            }
        }
        return requiredAutoDiagramChanges;
    }
}

