/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop.CreateCapsulePartAndDisplayCommand;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsuleToCapsulePartDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Capsule drop to create CapsulePart";
    }

    public String getDescription() {
        return "Capsule drop to create CapsulePart";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrusrt.umlrt.tooling.diagram.common.capsuleToCapsulePartDrop";
    }

    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        EObject targetElement;
        if (!(request instanceof DropObjectsRequest)) {
            return null;
        }
        DropObjectsRequest dropReq = this.getDropObjectsRequest(request);
        if (dropReq == null) {
            return null;
        }
        List<Classifier> handledDroppedObjects = this.getDroppedCapsules((Request)dropReq);
        if (!this.canHandleRequest(handledDroppedObjects, targetElement = this.getTargetSemanticElement(targetEditPart))) {
            return null;
        }
        Point location = dropReq.getLocation();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (EObject eObject : handledDroppedObjects) {
            compoundCommand.add(this.getCreateAndDropObjectCommand(eObject, (Classifier)targetElement, location, targetEditPart));
            location.performTranslate(20, 20);
        }
        return compoundCommand;
    }

    protected Command getCreateAndDropObjectCommand(EObject droppedObject, Classifier targetClassifier, Point location, EditPart targetEditPart) {
        CreateCapsulePartAndDisplayCommand command = new CreateCapsulePartAndDisplayCommand(targetClassifier, "org.eclipse.papyrusrt.umlrt.core.CapsulePart", UMLPackage.eINSTANCE.getNamespace_OwnedMember(), droppedObject, location, targetEditPart);
        return new ICommandProxy((ICommand)command);
    }

    protected List<Classifier> getDroppedCapsules(Request req) {
        List droppedObjects = this.getSourceEObjects(req);
        ArrayList<Classifier> result = new ArrayList<Classifier>();
        if (droppedObjects != null) {
            for (EObject droppedObject : droppedObjects) {
                if (!(droppedObject instanceof Classifier) || !CapsuleUtils.isCapsule((Classifier)((Classifier)droppedObject))) continue;
                result.add((Classifier)droppedObject);
            }
        }
        return result;
    }

    protected boolean canHandleRequest(List<Classifier> droppedObjects, EObject targetElement) {
        boolean result = false;
        if (!droppedObjects.isEmpty()) {
            result = targetElement instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)targetElement)) && droppedObjects.size() > 0;
        }
        return result;
    }
}

