/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.Either;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnectionPoint;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTReplicatedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTSwitch;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class EditPartInheritanceUtils {
    private EditPartInheritanceUtils() {
    }

    public static <T extends EObject> T resolveSemanticElement(EditPart editPart, java.lang.Class<T> type) {
        EObject result = editPart instanceof IGraphicalEditPart ? ((IGraphicalEditPart)editPart).resolveSemanticElement() : (editPart.getModel() instanceof View ? EditPartInheritanceUtils.resolveSemanticElement((View)editPart.getModel()) : null);
        return (T)((EObject)TypeUtils.as((Object)result, type));
    }

    public static EObject resolveSemanticElement(final IInheritableEditPart editPart, EObject result) {
        if (result == null) {
            return result;
        }
        return (EObject)new UMLSwitch<EObject>(){

            public EObject caseProperty(Property property) {
                Property redefiningProperty;
                Class context = editPart.resolveContext(Class.class);
                if (context != null && context != property.getClass_() && (redefiningProperty = EditPartInheritanceUtils.resolveRedefiningProperty(property, context)) != null) {
                    return redefiningProperty;
                }
                return property;
            }

            public EObject caseConnector(Connector connector) {
                UMLRTConnector facade = UMLRTConnector.getInstance((Connector)connector);
                if (facade != null) {
                    UMLRTCapsule capsule;
                    Class context = editPart.resolveContext(Class.class);
                    UMLRTCapsule uMLRTCapsule = capsule = context == null ? null : UMLRTCapsule.getInstance((Class)context);
                    if (context != null && (facade = (UMLRTConnector)capsule.getRedefinitionOf((UMLRTNamedElement)facade)) != null) {
                        return facade.toUML();
                    }
                }
                return connector;
            }

            public EObject caseRegion(Region region) {
                Either context = Either.or((Object)editPart.resolveContext(State.class), () -> editPart.resolveContext(StateMachine.class));
                return (EObject)context.flatMapEither(Namespace.class, namespace -> namespace.getOwnedMembers().stream().filter(Region.class::isInstance).map(Region.class::cast).filter(r -> UMLRTExtensionUtil.redefines((Element)r, (Element)region)).findFirst()).orElse(region);
            }

            public EObject casePseudostate(Pseudostate pseudostate) {
                UMLRTConnectionPoint facade;
                if (pseudostate.getState() != null && (facade = UMLRTConnectionPoint.getInstance((Pseudostate)pseudostate)) != null) {
                    UMLRTState context = UMLRTState.getInstance((State)editPart.resolveContext(State.class));
                    return (EObject)Optional.ofNullable(context).map(state -> (UMLRTConnectionPoint)state.getRedefinitionOf((UMLRTNamedElement)facade)).map(UMLRTConnectionPoint::toUML).orElse(pseudostate);
                }
                return null;
            }

            public EObject caseVertex(Vertex vertex) {
                UMLRTVertex facade = UMLRTVertex.getInstance((Vertex)vertex);
                if (facade != null) {
                    Either context = Either.or((Object)editPart.resolveContext(State.class), () -> editPart.resolveContext(StateMachine.class));
                    return (EObject)context.mapEither(Namespace.class, namespace -> {
                        UMLRTNamedElement stateOrSM = UMLRTFactory.create((NamedElement)namespace);
                        return stateOrSM != null ? (UMLRTVertex)stateOrSM.getRedefinitionOf((UMLRTNamedElement)facade) : null;
                    }).map(UMLRTNamedElement::toUML).orElse((NamedElement)vertex);
                }
                return vertex;
            }

            public EObject caseTransition(Transition transition) {
                UMLRTTransition facade = UMLRTTransition.getInstance((Transition)transition);
                if (facade != null) {
                    Either context = Either.or((Object)editPart.resolveContext(State.class), () -> editPart.resolveContext(StateMachine.class));
                    return (EObject)context.mapEither(Namespace.class, namespace -> {
                        UMLRTNamedElement stateOrSM = UMLRTFactory.create((NamedElement)namespace);
                        return stateOrSM != null ? (UMLRTTransition)stateOrSM.getRedefinitionOf((UMLRTNamedElement)facade) : null;
                    }).map(UMLRTNamedElement::toUML).orElse((NamedElement)transition);
                }
                return transition;
            }

            public EObject defaultCase(EObject object) {
                return object;
            }
        }.doSwitch(result);
    }

    static Property resolveRedefiningProperty(Property inheritedProperty, Class context) {
        return EditPartInheritanceUtils.resolveRedefiningProperty(inheritedProperty, UMLRTCapsule.getInstance((Class)context));
    }

    static <T extends Property> T resolveRedefiningProperty(T inheritedProperty, UMLRTCapsule capsule) {
        Property result = null;
        UMLRTReplicatedElement redefined = (UMLRTReplicatedElement)UMLRTFactory.create(inheritedProperty);
        if (capsule != null && redefined != null) {
            result = (redefined instanceof UMLRTPort ? capsule.getPorts() : capsule.getCapsuleParts()).stream().filter(p -> p.redefines((UMLRTNamedElement)redefined)).findFirst().map(UMLRTReplicatedElement::toUML).orElse(null);
        }
        return (T)result;
    }

    public static UMLRTCapsule getContextCapsule(View view) {
        UMLRTCapsule result = null;
        View next = view;
        while (result == null && next != null) {
            EObject semantic = ViewUtil.resolveSemanticElement((View)next);
            if (semantic instanceof Class) {
                result = UMLRTCapsule.getInstance((Class)((Class)semantic));
            }
            next = ViewUtil.getContainerView((View)next);
        }
        return result;
    }

    public static UMLRTStateMachine getContextStateMachine(View view) {
        UMLRTStateMachine result = null;
        View next = view;
        while (result == null && next != null) {
            EObject semantic = ViewUtil.resolveSemanticElement((View)next);
            if (semantic instanceof StateMachine) {
                result = UMLRTStateMachine.getInstance((StateMachine)((StateMachine)semantic));
            } else if (semantic instanceof State && ViewUtil.getContainerView((View)next) == null) {
                result = UMLRTStateMachine.getInstance((StateMachine)((State)semantic).containingStateMachine());
            }
            next = ViewUtil.getContainerView((View)next);
        }
        return result;
    }

    public static EObject resolveSemanticElement(View view) {
        EObject result = ViewUtil.resolveSemanticElement((View)view);
        UMLRTCapsule capsule = EditPartInheritanceUtils.getContextCapsule(view);
        if (capsule != null) {
            FacadeObject facade = UMLRTFactory.create((EObject)result);
            if (facade != null) {
                result = EditPartInheritanceUtils.resolve(capsule, facade, view).toUML();
            }
        } else {
            UMLRTStateMachine stateMachine = EditPartInheritanceUtils.getContextStateMachine(view);
            if (stateMachine != null) {
                if (result instanceof Region) {
                    Either container = Either.or(Optional.ofNullable(((Region)result).getState()).map(UMLRTState::getInstance), () -> Optional.of(stateMachine));
                    List regions = (List)(container = container.map(state -> (UMLRTState)stateMachine.getRedefinitionOf((UMLRTNamedElement)state))).map(state -> UMLRTExtensionUtil.getUMLRTContents((EObject)state.toUML(), (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]), sm -> UMLRTExtensionUtil.getUMLRTContents((EObject)sm.toUML(), (EStructuralFeature)UMLPackage.Literals.STATE_MACHINE__REGION, (EStructuralFeature[])new EStructuralFeature[0])).getEither();
                    if (!regions.isEmpty()) {
                        result = (EObject)regions.get(0);
                    }
                } else {
                    FacadeObject facade = UMLRTFactory.create((EObject)result);
                    if (facade != null) {
                        result = EditPartInheritanceUtils.resolve(stateMachine, facade).toUML();
                    }
                }
            }
        }
        return result;
    }

    static <T extends FacadeObject> T resolve(final UMLRTCapsule semanticContext, T element, final View view) {
        UMLRTSwitch switch_ = new UMLRTSwitch<T>(){

            public T casePort(UMLRTPort port) {
                return EditPartInheritanceUtils.resolvePort(port.toUML(), semanticContext, view);
            }

            public T caseCapsulePart(UMLRTCapsulePart capsulePart) {
                return EditPartInheritanceUtils.resolveCapsulePart(capsulePart.toUML(), semanticContext, view);
            }

            public T defaultCase(EObject object) {
                return (FacadeObject)object;
            }
        };
        return (T)((FacadeObject)switch_.doSwitch(element));
    }

    public static UMLRTPort resolvePort(Port uml, UMLRTCapsule capsule, View portView) {
        UMLRTPort result = null;
        View portParentView = ViewUtil.getContainerView((View)portView);
        EObject portParent = ViewUtil.resolveSemanticElement((View)portParentView);
        if (portParent instanceof Property) {
            UMLRTCapsule type;
            UMLRTCapsulePart part = EditPartInheritanceUtils.resolveCapsulePart((Property)portParent, capsule, portParentView);
            if (part != null && (type = part.getType()) != null) {
                result = UMLRTPort.getInstance((Port)EditPartInheritanceUtils.resolveRedefiningProperty(uml, type));
            }
        } else {
            result = UMLRTPort.getInstance((Port)EditPartInheritanceUtils.resolveRedefiningProperty(uml, capsule));
        }
        return result;
    }

    public static UMLRTCapsulePart resolveCapsulePart(Property uml, UMLRTCapsule capsule, View partView) {
        Property result = EditPartInheritanceUtils.resolveRedefiningProperty(uml, capsule);
        return result == null ? UMLRTCapsulePart.getInstance((Property)uml) : UMLRTCapsulePart.getInstance((Property)result);
    }

    static <T extends FacadeObject> T resolve(final UMLRTStateMachine semanticContext, T element) {
        UMLRTSwitch switch_ = new UMLRTSwitch<T>(){

            public T caseConnectionPoint(UMLRTConnectionPoint connectionPoint) {
                UMLRTState state = EditPartInheritanceUtils.resolve(semanticContext, connectionPoint.getState());
                return state.getRedefinitionOf((UMLRTNamedElement)connectionPoint);
            }

            public T caseVertex(UMLRTVertex vertex) {
                Either container = Either.or((Object)vertex.getState(), () -> semanticContext);
                container = container.map(state -> EditPartInheritanceUtils.resolve(semanticContext, state));
                return container.mapEither(UMLRTNamedElement.class, c -> (UMLRTVertex)c.getRedefinitionOf((UMLRTNamedElement)vertex)).orElse(null);
            }

            public T caseTransition(UMLRTTransition transition) {
                Either container = Either.or((Object)transition.getState(), () -> semanticContext);
                container = container.map(state -> EditPartInheritanceUtils.resolve(semanticContext, state));
                return container.mapEither(UMLRTNamedElement.class, c -> (UMLRTTransition)c.getRedefinitionOf((UMLRTNamedElement)transition)).orElse(null);
            }

            public T defaultCase(EObject object) {
                return (FacadeObject)object;
            }
        };
        return (T)((FacadeObject)switch_.doSwitch(element));
    }

    public static Object getAdapter(IGraphicalEditPart editPart, java.lang.Class key, Object result) {
        View view;
        if (result instanceof EObject && (view = editPart.getNotationView()) != null && result == view.getElement() && !view.eIsProxy()) {
            result = editPart.resolveSemanticElement();
        }
        return result;
    }

    public static <T extends UMLRTNamedElement> Optional<T> getGraphicalRedefinitionContext(UMLRTNamedElement rtElement, java.lang.Class<T> contextType) {
        NamedElement element;
        UMLRTNamedElement result = null;
        NamedElement namedElement = element = rtElement == null ? null : rtElement.toUML();
        if (element != null) {
            Element owner = element.getOwner();
            while (result == null && owner != null) {
                if (owner instanceof Namespace) {
                    Namespace namespace = (Namespace)owner;
                    result = (UMLRTNamedElement)TypeUtils.as((Object)UMLRTFactory.create((NamedElement)namespace), contextType);
                }
                owner = owner.getOwner();
            }
        }
        return Optional.ofNullable(result);
    }

    public static UMLRTCapsule getContextCapsule(UMLRTNamedElement rtElement) {
        return EditPartInheritanceUtils.getGraphicalRedefinitionContext(rtElement, UMLRTCapsule.class).orElse(null);
    }

    public static Either<UMLRTState, UMLRTStateMachine> getStateMachineContext(UMLRTNamedElement rtElement) {
        return Either.or(EditPartInheritanceUtils.getGraphicalRedefinitionContext(rtElement, UMLRTState.class), () -> EditPartInheritanceUtils.getGraphicalRedefinitionContext(rtElement, UMLRTStateMachine.class));
    }

    public static Either<UMLRTState, UMLRTStateMachine> getStateMachineContext(View view) {
        Diagram diagram = view.getDiagram();
        return diagram == null ? Either.empty() : Either.cast((Object)diagram.getElement(), State.class, StateMachine.class).map(UMLRTState::getInstance, UMLRTStateMachine::getInstance);
    }

    public static Command getCreateElementAndViewCommand(IGraphicalEditPart editPart, CreateViewAndElementRequest request, Function<? super CreateViewAndElementRequest, ? extends Command> createView) {
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        View view = editPart.getNotationView();
        EObject hostElement = editPart.resolveSemanticElement();
        if (hostElement == null && view.getElement() == null) {
            hostElement = view;
        }
        if (hostElement == null) {
            return null;
        }
        createElementRequest.setContainer(hostElement);
        Command createElementCommand = editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)createElementRequest, request.getExtendedData()));
        if (createElementCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!createElementCommand.canExecute()) {
            return createElementCommand;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        Command viewCommand = createView.apply((CreateViewAndElementRequest)request);
        Command refreshConnectionsCommand = editPart.getCommand((Request)new RefreshConnectionsRequest((List)request.getNewObject()));
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        if (refreshConnectionsCommand != null) {
            cc.compose((IUndoableOperation)new CommandProxy(refreshConnectionsCommand));
        }
        return new ICommandProxy((ICommand)cc);
    }

    public static Command getCreateCommand(IGraphicalEditPart editPart, CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = editPart.getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            CreateCommand createCommand = new CreateCommand(editingDomain, descriptor, editPart.getNotationView());
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    public static void handleNotificationEvent(IGraphicalEditPart editPart, Notification notification, Consumer<? super Notification> defaultHandler) {
        block7: {
            block6: {
                Object feature = notification.getFeature();
                Object notifier = notification.getNotifier();
                if (feature != NotationPackage.Literals.VIEW__ELEMENT || notifier != editPart.getModel() && (!(editPart instanceof CompartmentEditPart) || editPart.getParent() == null || notifier != editPart.getParent().getModel())) break block6;
                switch (notification.getEventType()) {
                    case 1: 
                    case 2: {
                        EObject oldSemantic = (EObject)notification.getOldValue();
                        EObject newSemantic = (EObject)notification.getNewValue();
                        if (!(oldSemantic instanceof Region) || !(newSemantic instanceof Region)) {
                            defaultHandler.accept((Notification)notification);
                            break;
                        }
                        Region oldRegion = (Region)oldSemantic;
                        Region newRegion = (Region)newSemantic;
                        if (oldRegion == newRegion || UMLRTExtensionUtil.redefines((Element)oldRegion, (Element)newRegion) || UMLRTExtensionUtil.redefines((Element)newRegion, (Element)oldRegion)) break block7;
                        defaultHandler.accept((Notification)notification);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block7;
            }
            defaultHandler.accept((Notification)notification);
        }
    }
}

