/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.FacadeValueProperty;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

class FacadeSingleReferenceProperty<S extends UMLRTNamedElement, T extends UMLRTNamedElement>
extends FacadeValueProperty<S, T> {
    FacadeSingleReferenceProperty(Class<T> elementType, List<? extends EStructuralFeature> features, Function<? super S, ? extends T> accessor) {
        super(elementType, features, accessor);
    }

    @Override
    T fromModel(Object o) {
        return (T)((UMLRTNamedElement)super.fromModel(UMLRTFactory.create((NamedElement)((NamedElement)o))));
    }

    @Override
    Object toModel(T value) {
        return value == null ? null : value.toUML();
    }

    @Override
    protected List<? extends ICommand> getCommands(S source, ValueDiff<T> diff) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source.toUML());
        ArrayList<ICommand> result = new ArrayList<ICommand>();
        if (diff.getOldValue() != null) {
            UMLRTNamedElement element = (UMLRTNamedElement)diff.getOldValue();
            switch (element.getInheritanceKind()) {
                case INHERITED: 
                case REDEFINED: {
                    result.add(ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, (Element)element.toUML(), (boolean)true));
                    break;
                }
                case NONE: {
                    DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)element.toUML(), false);
                    IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)element.toUML());
                    ICommand destroy = edit.getEditCommand((IEditCommandRequest)request);
                    result.add(destroy);
                    break;
                }
            }
        }
        result.add(this.getSetCommand(domain, source, Optional.ofNullable((UMLRTNamedElement)diff.getNewValue())));
        return result;
    }
}

