/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.requests.UnsetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.IFacadeProperty;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;

class FacadeValueProperty<S extends UMLRTNamedElement, T>
extends SimpleValueProperty<S, T>
implements IFacadeProperty {
    private final Class<T> elementType;
    private final List<? extends EStructuralFeature> features;
    private final Function<? super S, ? extends T> accessor;

    FacadeValueProperty(Class<T> elementType, List<? extends EStructuralFeature> features, Function<? super S, ? extends T> accessor) {
        this.elementType = elementType;
        this.features = features;
        this.accessor = accessor;
    }

    public Object getValueType() {
        return this.elementType;
    }

    @Override
    public String getPropertyName() {
        return this.features.get(0).getName();
    }

    protected T doGetValue(S source) {
        return this.accessor.apply(source);
    }

    T fromModel(Object o) {
        return this.elementType.cast(o);
    }

    Object toModel(T value) {
        return value;
    }

    protected void doSetValue(S source, T value) {
        TransactionalEditingDomain domain;
        CompositeTransactionalCommand command;
        List<ICommand> commands = this.getCommands(source, Diffs.createValueDiff((Object)this.getValue(source), value));
        if (!commands.isEmpty() && (command = new CompositeTransactionalCommand(domain = TransactionUtil.getEditingDomain((EObject)source.toUML()), "Edit " + this.getPropertyName(), commands)).canExecute()) {
            domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)command.reduce()));
        }
    }

    protected EObject getValueOwner(S source) {
        return source.toUML();
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
        class NativeListener
        extends AdapterImpl
        implements INativePropertyListener<S> {
            private S source;
            private final /* synthetic */ ISimplePropertyListener val$listener;

            NativeListener(ISimplePropertyListener iSimplePropertyListener) {
                this.val$listener = iSimplePropertyListener;
            }

            public void addTo(S source) {
                EObject listOwner = FacadeValueProperty.this.getValueOwner(source);
                listOwner.eAdapters().add((Object)this);
                this.source = source;
            }

            public void removeFrom(S source) {
                if (source != null) {
                    EObject listOwner = FacadeValueProperty.this.getValueOwner(source);
                    if (listOwner != null) {
                        listOwner.eAdapters().remove((Object)this);
                    }
                    source = null;
                }
            }

            public void notifyChanged(Notification msg) {
                ValueDiff diff = null;
                if (FacadeValueProperty.this.features.contains(msg.getFeature())) {
                    switch (msg.getEventType()) {
                        case 1: 
                        case 2: 
                        case 9: {
                            diff = Diffs.createValueDiff(FacadeValueProperty.this.fromModel(msg.getOldValue()), FacadeValueProperty.this.fromModel(msg.getNewValue()));
                        }
                    }
                }
                if (diff != null) {
                    this.val$listener.handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, this.source, (IProperty)FacadeValueProperty.this, diff));
                }
            }
        }
        return new NativeListener(listener);
    }

    protected List<? extends ICommand> getCommands(S source, ValueDiff<T> diff) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source.toUML());
        ArrayList<ICommand> result = new ArrayList<ICommand>(1);
        Optional<Object> newValue = Optional.ofNullable(diff.getNewValue());
        result.add(this.getSetCommand(domain, source, newValue));
        return result;
    }

    protected ICommand getSetCommand(TransactionalEditingDomain domain, S source, Optional<T> newValue) {
        EObject valueOwner = this.getValueOwner(source);
        IEditCommandRequest request = newValue.map(elem -> new SetRequest(domain, valueOwner, this.features.get(0), this.toModel(elem))).orElseGet(() -> new UnsetRequest(domain, valueOwner, this.features.get(0)));
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)valueOwner);
        return edit.getEditCommand(request);
    }
}

