/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.system.profile.util.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.CompositeValidator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.ChangeListenerUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartKindObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindObservableValue;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePartKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPortKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.provider.UMLRTEditPlugin;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class RTStereotypeModelElement
extends StereotypeModelElement {
    public RTStereotypeModelElement(EObject stereoApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereoApplication, stereotype, domain);
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean editable = true;
        EStructuralFeature feature = this.getFeature(propertyPath);
        EObject source = this.getSource();
        if (source instanceof RTPort) {
            RTPort rtPort = (RTPort)source;
            UMLRTPort port = UMLRTPort.getInstance((Port)rtPort.getBase_Port());
            if (port != null) {
                UMLRTProtocol protocol = port.getType();
                if (protocol != null && SystemElementsUtils.isSystemProtocol((Collaboration)protocol.toUML())) {
                    editable = false;
                } else if ("kind".equals(propertyPath)) {
                    editable = true;
                } else if (feature == UMLRealTimePackage.Literals.RT_PORT__IS_NOTIFICATION) {
                    editable = port.isBehavior();
                } else if (feature == UMLRealTimePackage.Literals.RT_PORT__IS_WIRED) {
                    editable = !port.isInherited();
                    editable = editable && port.isBehavior() && !port.isConnected() && !RTPortUtils.isLegacySpp((Port)port.toUML()) && !RTPortUtils.isLegacySap((Port)port.toUML());
                } else {
                    editable = feature == UMLRealTimePackage.Literals.RT_PORT__IS_PUBLISH ? false : (feature == UMLRealTimePackage.Literals.RT_PORT__REGISTRATION ? !rtPort.isWired() && !port.isInherited() : (feature == UMLRealTimePackage.Literals.RT_PORT__REGISTRATION_OVERRIDE ? !rtPort.isWired() && !port.isInherited() : super.isFeatureEditable(propertyPath)));
                }
            }
        } else {
            editable = source instanceof CapsulePart ? true : super.isFeatureEditable(propertyPath);
        }
        return editable;
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observe = null;
        if ("kind".equals(propertyPath)) {
            EObject source = this.getSource();
            if (source instanceof RTPort) {
                observe = new PortRTKindObservableValue(source, (TransactionalEditingDomain)this.domain);
            } else if (source instanceof CapsulePart) {
                observe = new CapsulePartKindObservableValue(source, (TransactionalEditingDomain)this.domain);
            }
        } else {
            observe = super.doGetObservable(propertyPath);
        }
        if (this.getSource() instanceof RTPort) {
            observe.addChangeListener((IChangeListener)new RTStereotypeModelElementChangeListener());
        }
        return observe;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        IStaticContentProvider provider = null;
        EObject source = this.getSource();
        if ("kind".equals(propertyPath) && source instanceof RTPort) {
            ArrayList validKinds = new ArrayList(UMLRTPortKind.VALUES);
            validKinds.remove(UMLRTPortKind.NULL);
            provider = new StaticContentProvider(validKinds.toArray());
        } else if ("kind".equals(propertyPath) && source instanceof CapsulePart) {
            ArrayList validKinds = new ArrayList(UMLRTCapsulePartKind.VALUES);
            validKinds.remove(UMLRTCapsulePartKind.NULL);
            provider = new StaticContentProvider(validKinds.toArray());
        } else {
            provider = super.getContentProvider(propertyPath);
        }
        return provider;
    }

    public IValidator getValidator(String propertyPath) {
        IValidator result = super.getValidator(propertyPath);
        if ("kind".equals(propertyPath)) {
            result = CompositeValidator.of(result, enumValue -> {
                if (this.source instanceof RTPort && enumValue instanceof UMLRTPortKind ? RTPortUtils.isKindEditable((Port)((RTPort)this.source).getBase_Port(), (UMLRTPortKind)((UMLRTPortKind)enumValue)) : this.source instanceof CapsulePart && enumValue instanceof UMLRTCapsulePartKind && CapsulePartUtils.isKindEditable((Property)((CapsulePart)this.source).getBase_Property(), (UMLRTCapsulePartKind)((UMLRTCapsulePartKind)enumValue))) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            });
        }
        return result;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        switch (propertyPath) {
            case "registration": {
                if (!(this.source instanceof RTPort)) break;
                return new EnumLabelProvider(UMLRealTimePackage.Literals.PORT_REGISTRATION_TYPE);
            }
            case "kind": {
                Object enumType = this.source instanceof RTPort ? UMLRTUMLRTPackage.Literals.UMLRT_PORT_KIND : (this.source instanceof CapsulePart ? UMLRTUMLRTPackage.Literals.UMLRT_CAPSULE_PART_KIND : null);
                if (enumType == null) break;
                return new EnumLabelProvider((EEnum)enumType);
            }
        }
        return super.getLabelProvider(propertyPath);
    }

    public boolean forceRefresh(String propertyPath) {
        return true;
    }

    boolean isViable() {
        boolean result;
        Object selected;
        Object object = selected = this.dataSource != null ? this.dataSource.getSelection().getFirstElement() : null;
        if (selected == null) {
            result = false;
        } else {
            View view = (View)PlatformHelper.getAdapter((Object)selected, View.class);
            boolean bl = result = view == null || view.eResource() != null;
            if (result) {
                EObject source = this.getSource();
                result = source != null && source.eResource() != null;
            }
        }
        return result;
    }

    protected static class EnumLabelProvider
    extends LabelProvider {
        private final EEnum enumType;

        public EnumLabelProvider(EEnum enumType) {
            this.enumType = enumType;
        }

        public String getText(Object element) {
            if (element instanceof Enumerator) {
                Enumerator literal = (Enumerator)element;
                String key = String.format("_UI_%s_%s_literal", this.enumType.getName(), literal.getName());
                return UMLRTEditPlugin.INSTANCE.getString(key);
            }
            return super.getText(element);
        }
    }

    public class RTStereotypeModelElementChangeListener
    implements IChangeListener {
        public void handleChange(ChangeEvent event) {
            if (RTStereotypeModelElement.this.isViable()) {
                try {
                    ChangeListenerUtils.fireDataSourceChanged(RTStereotypeModelElement.this.dataSource);
                }
                catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                    Activator.log.debug(e.getMessage());
                }
            }
        }
    }
}

