/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MultiplicityElementAdapter;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePartKind;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CapsulePartKindObservableValue
extends PapyrusObservableValue
implements IObserving {
    private static final String LABEL_MULTIPLICITY = "Set Multiplicity";
    private static final String LABEL_AGGREGATION = "Set Aggregation";
    private Property capsulePartElement;
    private PartAdapter partAdapter;
    private Object value;

    public CapsulePartKindObservableValue(EObject rtApplication, TransactionalEditingDomain domain) {
        super((EObject)UMLUtil.getBaseElement((EObject)rtApplication), UMLUtil.getBaseElement((EObject)rtApplication).eContainingFeature(), (EditingDomain)domain, GMFtoEMFCommandWrapper::wrap);
        if (rtApplication instanceof CapsulePart) {
            this.capsulePartElement = (Property)UMLUtil.getBaseElement((EObject)rtApplication);
            this.getPartAdapter().adapt((Notifier)this.capsulePartElement);
        }
    }

    public synchronized void dispose() {
        try {
            if (this.partAdapter != null) {
                if (this.partAdapter.getTarget() != null) {
                    this.partAdapter.unadapt((Notifier)this.partAdapter.getTarget());
                }
                this.partAdapter = null;
            }
            this.value = null;
        }
        finally {
            super.dispose();
        }
    }

    protected Object doGetValue() {
        AggregationKind aggregation = this.capsulePartElement.getAggregation();
        UMLRTCapsulePartKind newValue = this.capsulePartElement.getLower() > 0 && this.capsulePartElement.getUpper() > 0 ? UMLRTCapsulePartKind.FIXED : (this.capsulePartElement.getLower() == 0 || this.capsulePartElement.getUpper() == -1 ? (AggregationKind.COMPOSITE_LITERAL.equals((Object)aggregation) ? UMLRTCapsulePartKind.OPTIONAL : UMLRTCapsulePartKind.PLUG_IN) : UMLRTCapsulePartKind.OPTIONAL);
        this.value = newValue;
        return this.value;
    }

    public Command getCommand(Object value) {
        ValueSpecification upperValue = this.capsulePartElement.getUpperValue();
        LiteralInteger newLowerValue = null;
        if (upperValue == null || upperValue instanceof LiteralUnlimitedNatural) {
            newLowerValue = (LiteralInteger)ModelUtils.create((EObject)this.capsulePartElement, (EClass)UMLPackage.Literals.LITERAL_INTEGER);
            newLowerValue.setValue(0);
        } else if (upperValue instanceof OpaqueExpression) {
            newLowerValue = (OpaqueExpression)ModelUtils.create((EObject)this.capsulePartElement, (EClass)UMLPackage.Literals.OPAQUE_EXPRESSION);
        } else if (upperValue instanceof LiteralString) {
            newLowerValue = (LiteralString)ModelUtils.create((EObject)this.capsulePartElement, (EClass)UMLPackage.Literals.LITERAL_STRING);
        }
        AggregationKind newAggregation = AggregationKind.COMPOSITE_LITERAL;
        if (value instanceof UMLRTCapsulePartKind) {
            switch ((UMLRTCapsulePartKind)value) {
                case FIXED: {
                    this.setLowerValue(upperValue, (ValueSpecification)newLowerValue);
                    newAggregation = AggregationKind.COMPOSITE_LITERAL;
                    break;
                }
                case OPTIONAL: {
                    newLowerValue = (LiteralInteger)ModelUtils.create((EObject)this.capsulePartElement, (EClass)UMLPackage.Literals.LITERAL_INTEGER);
                    newLowerValue.setValue(0);
                    newAggregation = AggregationKind.COMPOSITE_LITERAL;
                    break;
                }
                case PLUG_IN: {
                    newLowerValue = (LiteralInteger)ModelUtils.create((EObject)this.capsulePartElement, (EClass)UMLPackage.Literals.LITERAL_INTEGER);
                    newLowerValue.setValue(0);
                    newAggregation = AggregationKind.SHARED_LITERAL;
                    break;
                }
                default: {
                    this.setLowerValue(upperValue, (ValueSpecification)newLowerValue);
                    newAggregation = AggregationKind.COMPOSITE_LITERAL;
                }
            }
        }
        Command command = this.getCommandForCapsulePart((ValueSpecification)newLowerValue, newAggregation);
        return command;
    }

    protected Command getCommandForCapsulePart(ValueSpecification newLowerValue, AggregationKind newAggregation) {
        CompoundCommand command = new CompoundCommand();
        command.append(this.getSetAggregationCommand(newAggregation));
        command.append(this.getSetMultiplicityCommand(newLowerValue));
        return command;
    }

    private void setLowerValue(ValueSpecification upperValue, ValueSpecification newLowerValue) {
        if (upperValue == null) {
            ((LiteralInteger)newLowerValue).setValue(1);
        } else if (upperValue instanceof LiteralUnlimitedNatural) {
            if (((LiteralUnlimitedNatural)upperValue).getValue() != -1) {
                ((LiteralInteger)newLowerValue).setValue(((LiteralUnlimitedNatural)upperValue).getValue());
            }
        } else if (upperValue instanceof LiteralString) {
            ((LiteralString)newLowerValue).setValue(((LiteralString)upperValue).getValue());
        } else if (upperValue instanceof OpaqueExpression) {
            OpaqueExpression opaqueUpper = (OpaqueExpression)upperValue;
            OpaqueExpression opaqueLower = (OpaqueExpression)newLowerValue;
            ECollections.setEList((EList)opaqueLower.getBodies(), (List)opaqueUpper.getBodies());
            ECollections.setEList((EList)opaqueLower.getLanguages(), (List)opaqueUpper.getLanguages());
        }
    }

    protected Command getSetMultiplicityCommand(final ValueSpecification newLowerValue) {
        RecordingCommand multiplicityCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                if (newLowerValue.eClass().isInstance((Object)CapsulePartKindObservableValue.this.capsulePartElement.getLowerValue())) {
                    new UMLSwitch<ValueSpecification>(){

                        public ValueSpecification caseLiteralInteger(LiteralInteger object) {
                            object.setValue(((LiteralInteger)newLowerValue).getValue());
                            return object;
                        }

                        public ValueSpecification caseOpaqueExpression(OpaqueExpression object) {
                            OpaqueExpression newOpaqueExpr = (OpaqueExpression)newLowerValue;
                            ECollections.setEList((EList)object.getBodies(), (List)newOpaqueExpr.getBodies());
                            ECollections.setEList((EList)object.getLanguages(), (List)newOpaqueExpr.getLanguages());
                            return object;
                        }

                        public ValueSpecification caseLiteralString(LiteralString object) {
                            object.setValue(((LiteralString)newLowerValue).getValue());
                            return object;
                        }

                        public ValueSpecification caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
                            object.setValue(((LiteralUnlimitedNatural)newLowerValue).getValue());
                            return object;
                        }
                    }.doSwitch((EObject)CapsulePartKindObservableValue.this.capsulePartElement.getLowerValue());
                } else {
                    CapsulePartKindObservableValue.this.capsulePartElement.setLowerValue(newLowerValue);
                }
            }

            public boolean canExecute() {
                return true;
            }

            public String getLabel() {
                return CapsulePartKindObservableValue.LABEL_MULTIPLICITY;
            }
        };
        return multiplicityCommand;
    }

    protected Command getSetAggregationCommand(final AggregationKind newAggregation) {
        RecordingCommand aggregationCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                CapsulePartKindObservableValue.this.capsulePartElement.setAggregation(newAggregation);
            }

            public boolean canExecute() {
                return true;
            }

            public String getLabel() {
                return CapsulePartKindObservableValue.LABEL_AGGREGATION;
            }
        };
        return aggregationCommand;
    }

    public Object getObserved() {
        return this.capsulePartElement;
    }

    public Object getValueType() {
        return UMLRTCapsulePartKind.class;
    }

    protected Adapter getMultiplicityListener() {
        return this.getPartAdapter();
    }

    protected Adapter getAggregationListener() {
        return this.getPartAdapter();
    }

    private MultiplicityElementAdapter getPartAdapter() {
        if (this.partAdapter == null) {
            this.partAdapter = new PartAdapter();
        }
        return this.partAdapter;
    }

    private class PartAdapter
    extends MultiplicityElementAdapter {
        PartAdapter() {
        }

        protected void handleMultiplicityChanged(Notification notification) {
            Object newValue;
            Object oldValue = CapsulePartKindObservableValue.this.value;
            if (!Objects.equals(oldValue, newValue = CapsulePartKindObservableValue.this.doGetValue())) {
                final ValueDiff diff = Diffs.createValueDiff((Object)oldValue, (Object)newValue);
                CapsulePartKindObservableValue.this.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        CapsulePartKindObservableValue.this.fireValueChange(diff);
                    }
                });
            }
        }
    }
}

