/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.AbstractCodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTOpaqueBehavior;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;

public class TransitionEffectTab
extends AbstractCodeSnippetTab {
    @Override
    public String getTitle() {
        return "Effect";
    }

    @Override
    public Image getImage() {
        Transition transition;
        Behavior effect;
        UMLRTInheritanceKind inheritance = UMLRTInheritanceKind.NONE;
        if (this.shouldShowThisTab(this.input) && (effect = (transition = (Transition)this.input).getEffect()) != null) {
            return this.getLabelProvider().getImage((Object)effect);
        }
        return Activator.getImage((String)Activator.getEffectSmallKey((UMLRTInheritanceKind)inheritance));
    }

    @Override
    public boolean shouldShowThisTab(EObject context) {
        if (context instanceof Transition) {
            Transition transition = (Transition)context;
            StateMachine sm = transition.containingStateMachine();
            return StateMachineUtils.isRTStateMachine((StateMachine)sm);
        }
        return false;
    }

    @Override
    protected IObservable getFeatureObservable() {
        if (this.meForFeatureObservable == null) {
            this.meForFeatureObservable = this.rtModelFactory.createFromSource((Object)this.input, null);
        }
        return this.meForFeatureObservable.getObservable("effect");
    }

    @Override
    protected ExpressionList getExpressionObservableList() {
        Transition transition = (Transition)this.input;
        return this.getExpressionList((EObject)transition.getEffect());
    }

    @Override
    protected void saveInitialExpression(ExpressionList.Expression ex) {
        UMLRTTransition transition = UMLRTFactory.createTransition((Transition)((Transition)this.input));
        UMLRTOpaqueBehavior ob = transition.createEffect(ex.getLanguage(), ex.getBody());
        ob.setName(this.getTitle());
    }

    @Override
    protected IObservable getSpecificationObservable() {
        return this.getSpecificationObservable((EObject)((Transition)this.input).getEffect());
    }
}

