/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.umlext.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util.InternalUpdateHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class UMLRTUMLPlugin
extends EMFPlugin {
    public static final UMLRTUMLPlugin INSTANCE = new UMLRTUMLPlugin();
    private static Implementation plugin;
    private static InternalUpdateHelper.Factory internalUpdateHelperFactory;

    static {
        internalUpdateHelperFactory = InternalUpdateHelper.Factory.DEFAULT;
    }

    public UMLRTUMLPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void setInternalUpdateHelperFactory(InternalUpdateHelper.Factory helperFactory) {
        internalUpdateHelperFactory = helperFactory == null ? InternalUpdateHelper.Factory.DEFAULT : helperFactory;
    }

    public static InternalUpdateHelper.Factory getInternalUpdateHelperFactory() {
        return internalUpdateHelperFactory;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private DelegatingInternalUpdateHelperFactory updateHelperFactory;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.updateHelperFactory = new DelegatingInternalUpdateHelperFactory(context);
            if (UMLRTUMLPlugin.getInternalUpdateHelperFactory() == InternalUpdateHelper.Factory.DEFAULT) {
                UMLRTUMLPlugin.setInternalUpdateHelperFactory(this.updateHelperFactory);
            }
        }

        public void stop(BundleContext context) throws Exception {
            if (UMLRTUMLPlugin.getInternalUpdateHelperFactory() == this.updateHelperFactory) {
                UMLRTUMLPlugin.setInternalUpdateHelperFactory(InternalUpdateHelper.Factory.DEFAULT);
            }
            this.updateHelperFactory.shutdown(context);
            this.updateHelperFactory = null;
            super.stop(context);
        }

        private static class DelegatingInternalUpdateHelperFactory
        implements InternalUpdateHelper.Factory,
        ServiceTrackerCustomizer<InternalUpdateHelper.Factory, InternalUpdateHelper.Factory> {
            private final BundleContext context;
            private final ServiceTracker<InternalUpdateHelper.Factory, InternalUpdateHelper.Factory> tracker;
            private List<InternalUpdateHelper.Factory> delegates = new ArrayList<InternalUpdateHelper.Factory>();

            DelegatingInternalUpdateHelperFactory(BundleContext context) {
                this.context = context;
                this.tracker = new ServiceTracker(context, InternalUpdateHelper.Factory.class, (ServiceTrackerCustomizer)this);
                this.tracker.open();
                Object[] services = this.tracker.getServices();
                if (services != null) {
                    Stream.of(services).filter(InternalUpdateHelper.Factory.class::isInstance).map(InternalUpdateHelper.Factory.class::cast).forEach(this.delegates::add);
                }
            }

            synchronized void shutdown(BundleContext context) {
                if (context == this.context) {
                    this.delegates.clear();
                    this.tracker.close();
                }
            }

            public synchronized InternalUpdateHelper.Factory addingService(ServiceReference<InternalUpdateHelper.Factory> reference) {
                InternalUpdateHelper.Factory result = (InternalUpdateHelper.Factory)this.context.getService(reference);
                if (result != null) {
                    this.delegates.add(result);
                }
                return result;
            }

            public synchronized void removedService(ServiceReference<InternalUpdateHelper.Factory> reference, InternalUpdateHelper.Factory service) {
                this.context.ungetService(reference);
                this.delegates.remove(service);
            }

            public void modifiedService(ServiceReference<InternalUpdateHelper.Factory> reference, InternalUpdateHelper.Factory service) {
            }

            @Override
            public InternalUpdateHelper create(Resource extensionResource) {
                return ((Stream)this.delegates.stream().sequential()).map(factory -> factory.create(extensionResource)).filter(Objects::nonNull).findFirst().orElseGet(() -> InternalUpdateHelper.Factory.DEFAULT.create(extensionResource));
            }
        }
    }
}

