/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CapsuleKind implements Enumerator
{
    FIXED(0, "FIXED", "FIXED"),
    OPTIONAL(1, "OPTIONAL", "OPTIONAL"),
    PLUGIN(2, "PLUGIN", "PLUGIN");

    public static final String copyright = "Copyright (c) 2014-2015 Zeligsoft (2009) Limited, IncQueryLabs Limited and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n";
    public static final int FIXED_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    public static final int PLUGIN_VALUE = 2;
    private static final CapsuleKind[] VALUES_ARRAY;
    public static final List<CapsuleKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CapsuleKind[]{FIXED, OPTIONAL, PLUGIN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CapsuleKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CapsuleKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CapsuleKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CapsuleKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CapsuleKind get(int value) {
        switch (value) {
            case 0: {
                return FIXED;
            }
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return PLUGIN;
            }
        }
        return null;
    }

    private CapsuleKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

