/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class UML2Util {
    public static Iterable<Class> getAllClasses(Model model) {
        EList _allOwnedElements = model.allOwnedElements();
        return Iterables.filter((Iterable)_allOwnedElements, Class.class);
    }

    public static Iterable<Class> getAllOnlyClasses(Model model) {
        EList _allOwnedElements = model.allOwnedElements();
        Functions.Function1<Element, Boolean> _function = new Functions.Function1<Element, Boolean>(){

            public Boolean apply(Element it) {
                EClass _eClass = it.eClass();
                String _name = _eClass.getName();
                return Objects.equal((Object)_name, (Object)"Class");
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allOwnedElements, (Functions.Function1)_function);
        Functions.Function1<Element, Class> _function_1 = new Functions.Function1<Element, Class>(){

            public Class apply(Element it) {
                return (Class)it;
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        return IterableExtensions.toList((Iterable)_map);
    }

    public static Collection<Class> getTopUMLClasses(Model model) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList((Object[])new Class[0]);
        EList _members = model.getMembers();
        for (NamedElement e : _members) {
            if (!(e instanceof Class)) continue;
            list.add((Class)e);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static StateMachine getStateMachine(Class klass) {
        boolean _tripleEquals;
        Behavior behaviour = klass.getClassifierBehavior();
        if (behaviour != null && behaviour instanceof StateMachine) {
            return (StateMachine)behaviour;
        }
        EList _ownedBehaviors = klass.getOwnedBehaviors();
        boolean bl = _tripleEquals = _ownedBehaviors == null;
        if (_tripleEquals) {
            return null;
        }
        EList _ownedBehaviors_1 = klass.getOwnedBehaviors();
        for (Behavior ownedBehaviour : _ownedBehaviors_1) {
            if (!(ownedBehaviour instanceof StateMachine)) continue;
            return (StateMachine)ownedBehaviour;
        }
        return null;
    }

    public static Class getUMLClass(Model model, String name) {
        EList _members = model.getMembers();
        for (NamedElement e : _members) {
            if (!(e instanceof Class) || !Objects.equal((Object)e.getName(), (Object)name)) continue;
            return (Class)e;
        }
        return null;
    }
}

