/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.designer.languages.common.base.codesync.ChangeObject;
import org.eclipse.papyrus.designer.languages.common.base.codesync.ManageChangeEvents;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AnsiCLibraryMetadata;
import org.eclipse.papyrusrt.codegen.cpp.ChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.UMLChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.XTUMLRT2CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.XTUMLRTChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.profile.facade.RTCppPropertiesProfileMetadata;
import org.eclipse.papyrusrt.codegen.utils.CodeGenUtils;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageManager;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageMetadata;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtModelTranslator;
import org.eclipse.papyrusrt.xtumlrt.trans.preproc.ModelPreprocessor;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractUMLRT2CppCodeGenerator {
    private static final ExternalPackageMetadata[] REQUIRED_PACKAGES = new ExternalPackageMetadata[]{RTCppPropertiesProfileMetadata.INSTANCE, AnsiCLibraryMetadata.INSTANCE};
    private static final IStatus OK_STATUS = new Status(0, "org.eclipse.papyrusrt.codegen", "ok");
    private static final ModelPreprocessor MODEL_PREPROCESSOR = new ModelPreprocessor();
    protected ExternalPackageManager externalPackageManager = ExternalPackageManager.getInstance();
    private ResourceSet resourceSet;
    private boolean standalone = true;
    private boolean regenerate = false;
    private boolean forceExternalPackageReset = true;
    private boolean sourceIsUML = true;
    private UML2xtumlrtModelTranslator translator;
    private XTUMLRT2CppCodeGenerator codegen;
    private CppCodePattern cpp;
    private ChangeTracker changeTracker;
    private Map<File, List<EObject>> targets;
    private Map<File, File> outputFolders;

    protected AbstractUMLRT2CppCodeGenerator() {
        this.reset();
    }

    private void reset() {
        this.translator = new UML2xtumlrtModelTranslator();
        this.cpp = new CppCodePattern(this.translator);
        this.changeTracker = this.sourceIsUML ? new UMLChangeTracker(this.cpp) : new XTUMLRTChangeTracker(this.cpp);
        this.codegen = new XTUMLRT2CppCodeGenerator(this.cpp, this.changeTracker);
        this.targets = new HashMap<File, List<EObject>>();
        this.outputFolders = new HashMap<File, File>();
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void setRegenerate(boolean flag) {
        this.regenerate = flag;
    }

    public boolean getRegenerate() {
        return this.regenerate;
    }

    public IStatus setupExternalPackageManagement(ResourceSet resourceSet) {
        IStatus success = OK_STATUS;
        this.externalPackageManager = ExternalPackageManager.getInstance();
        if (this.forceExternalPackageReset) {
            this.externalPackageManager.reset();
        }
        this.externalPackageManager.setResourceSet(resourceSet);
        this.externalPackageManager.setStandalone(this.standalone);
        ExternalPackageMetadata[] externalPackageMetadataArray = REQUIRED_PACKAGES;
        int n = REQUIRED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalPackageMetadata metadata = externalPackageMetadataArray[n2];
            this.externalPackageManager.addRequiredPackage(metadata);
            ++n2;
        }
        success = this.externalPackageManager.setup();
        return success;
    }

    public synchronized IStatus generate(List<EObject> elements, String top, boolean uml) {
        IStatus success = OK_STATUS;
        this.sourceIsUML = uml;
        this.reset();
        success = this.preGenerationTasks(elements, top);
        if (this.isOk(success)) {
            MultiStatus accumulatedStatus = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
            long start = System.currentTimeMillis();
            if (this.targets.isEmpty()) {
                accumulatedStatus.add(CodeGenPlugin.error((String)"Selection must contain at least one model element"));
            } else {
                try {
                    for (Map.Entry<File, List<EObject>> entry : this.targets.entrySet()) {
                        File modelFolder = entry.getKey();
                        List<EObject> elementsToGenerate = entry.getValue();
                        this.doGenerate(elementsToGenerate, modelFolder, accumulatedStatus);
                    }
                }
                catch (Throwable t) {
                    CodeGenPlugin.error((String)"Error during code generation.", (Throwable)t);
                    accumulatedStatus.add(CodeGenPlugin.error((Throwable)t));
                }
            }
            String message = "Generation " + (accumulatedStatus.getSeverity() <= 1 ? "complete" : "error") + ", elapsed time " + (System.currentTimeMillis() - start) + " ms";
            MultiStatus result = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, message, null);
            result.addAll((IStatus)accumulatedStatus);
            success = result;
        }
        return success;
    }

    protected IStatus preGenerationTasks(List<EObject> elements, String top) {
        IStatus success = OK_STATUS;
        success = this.setupResourceSet(elements);
        success = this.findTopCapsule(elements, top);
        if (this.isOk(success)) {
            this.collectFolders(elements);
            this.collectAllChangedElements(elements);
        }
        return success;
    }

    private IStatus setupResourceSet(List<EObject> elements) {
        IStatus success = OK_STATUS;
        ResourceSet elementsResourceSet = null;
        boolean first = true;
        for (EObject eobj : elements) {
            if (first || elementsResourceSet == null) {
                first = false;
                elementsResourceSet = eobj.eResource().getResourceSet();
                continue;
            }
            if (elementsResourceSet == eobj.eResource().getResourceSet()) continue;
            CodeGenPlugin.warning((String)"Target elements belong to different resource sets. This may result in errors during generation.");
        }
        if (elementsResourceSet != this.resourceSet || this.forceExternalPackageReset) {
            this.resourceSet = elementsResourceSet;
            success = this.setupExternalPackageManagement(this.resourceSet);
        }
        if (this.resourceSet == null) {
            success = new Status(4, "org.eclipse.papyrusrt.codegen", "Unable to inizialize the resource set.");
        }
        return success;
    }

    private boolean isOk(IStatus runningStatus) {
        return runningStatus == null || runningStatus.isOK();
    }

    private IStatus findTopCapsule(List<EObject> elements, String top) {
        IStatus success = OK_STATUS;
        EObject topCapsule = CodeGenUtils.findCapsule((EObject)elements.get(0), (String)top);
        if (topCapsule != null) {
            this.codegen.setTop(topCapsule);
            this.cpp.setTop(topCapsule);
        } else {
            success = new Status(4, "org.eclipse.papyrusrt.codegen", "Top capsule not found");
        }
        return success;
    }

    private void collectFolders(List<EObject> elements) {
        for (EObject eobj : elements) {
            File modelFolder = this.getModelFolder(eobj);
            List<EObject> list = this.targets.get(modelFolder);
            if (list == null) {
                list = new ArrayList<EObject>();
                this.targets.put(modelFolder, list);
            }
            list.add(eobj);
            File outputFolder = this.outputFolders.get(modelFolder);
            if (outputFolder != null) continue;
            outputFolder = this.getOutputFolder(eobj, this.codegen);
            this.outputFolders.put(modelFolder, outputFolder);
        }
    }

    private void collectAllChangedElements(List<EObject> elements) {
        ArrayList<ChangeObject> changes = new ArrayList<ChangeObject>();
        if (this.regenerate) {
            this.changeTracker.resetAll();
        }
        for (EObject eobj : elements) {
            this.getChanges(changes, eobj);
        }
        this.changeTracker.addChanges(changes);
    }

    private void getChanges(List<ChangeObject> changes, EObject object) {
        if (CodeGenPlugin.isStandalone() || CodeGenPlugin.isTextual()) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)object);
        if (domain != null) {
            EList changeList = ManageChangeEvents.getChangeList((TransactionalEditingDomain)domain);
            ManageChangeEvents.stopRecording((TransactionalEditingDomain)domain);
            ManageChangeEvents.initChangeList((TransactionalEditingDomain)domain, (boolean)true);
            if (changeList != null) {
                changes.addAll((Collection<ChangeObject>)changeList);
            }
        }
    }

    protected void doGenerate(List<EObject> inputElements, File modelFolder, MultiStatus accumulatedStatus) {
        List<EObject> elements = inputElements;
        File outputFolder = this.outputFolders.get(modelFolder);
        this.cpp.setOutputFolder(outputFolder);
        this.cpp.setModelFolder(modelFolder);
        Model xtumlrtModel = null;
        if (this.sourceIsUML) {
            try {
                elements = this.translateFromUMLtoXTUMLRT(elements, modelFolder, accumulatedStatus);
                xtumlrtModel = (Model)this.translator.getGenerated((Element)inputElements.get(0));
            }
            catch (Throwable t) {
                accumulatedStatus.add(CodeGenPlugin.error((String)"Error during translation from UML to XTUMLRT", (Throwable)t));
                t.printStackTrace(System.err);
                return;
            }
        } else {
            xtumlrtModel = (Model)inputElements.get(0);
        }
        MODEL_PREPROCESSOR.preprocess(xtumlrtModel);
        try {
            accumulatedStatus.addAll(this.codegen.generate(elements));
        }
        catch (Throwable t) {
            accumulatedStatus.add(CodeGenPlugin.error((String)"Error during generation from XTUMLRT to Cpp", (Throwable)t));
            t.printStackTrace(System.err);
            return;
        }
        long writeStart = System.currentTimeMillis();
        if (this.cpp.write()) {
            accumulatedStatus.add(CodeGenPlugin.info((String)("Updated generated files " + (System.currentTimeMillis() - writeStart) + "ms")));
        } else {
            accumulatedStatus.add(CodeGenPlugin.error((String)"Failed to write generated model to disk"));
        }
    }

    private List<EObject> translateFromUMLtoXTUMLRT(List<EObject> elements, File modelFolder, MultiStatus status) {
        Path path = modelFolder.toPath();
        List translated = null;
        this.translator.setChangeSet(this.codegen.getChangeTracker().getAllChanged());
        status.addAll(this.translator.generate(elements, path));
        translated = this.translator.getAllGenerated();
        if (translated == null || translated.isEmpty()) {
            status.add((IStatus)new Status(2, "org.eclipse.papyrusrt.codegen", "Unable to translate elements from UML to XTUMLRT"));
        }
        return translated;
    }

    protected abstract File getModelFolder(EObject var1);

    protected abstract File getOutputFolder(EObject var1, XTUMLRT2CppCodeGenerator var2);

    protected void resetResource(EObject context, XTUMLRT2CppCodeGenerator codeGen) {
        if (codeGen != null) {
            Resource resource = context.eResource();
            codeGen.getChangeTracker().closeResource(resource);
        }
    }
}

