/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractElementGenerator;
import org.eclipse.papyrusrt.codegen.cpp.ChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.GeneratorManager;
import org.eclipse.papyrusrt.codegen.cpp.profile.facade.RTCppGenerationProperties;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.xtumlrt.common.Artifact;
import org.eclipse.papyrusrt.xtumlrt.common.Behaviour;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypeDefinition;
import org.eclipse.papyrusrt.xtumlrt.common.util.CommonSwitch;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.statemach.StatemachFactory;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtModelTranslator;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTModel;
import org.eclipse.papyrusrt.xtumlrt.util.GeneralUtil;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;

public class XTUMLRT2CppCodeGenerator {
    public static UML2xtumlrtModelTranslator translator;
    private final CppCodePattern cpp;
    private EObject top;
    private ChangeTracker changeTracker;

    public XTUMLRT2CppCodeGenerator(CppCodePattern cpp, ChangeTracker changeTracker) {
        this.cpp = cpp;
        translator = cpp.getTranslator();
        this.changeTracker = changeTracker;
    }

    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    public void setTop(EObject topCapsule) {
        this.top = topCapsule;
        this.changeTracker.setTop(topCapsule);
    }

    public IStatus generate(List<EObject> inputElements) {
        long start = System.currentTimeMillis();
        MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 0, "UML-RT Code Generation", null);
        LinkedHashMap<GeneratorKey, AbstractElementGenerator> generators = new LinkedHashMap<GeneratorKey, AbstractElementGenerator>();
        Collector collector = new Collector(generators);
        for (EObject target : inputElements) {
            if (!this.toBeGenerated(target) || ((Boolean)collector.doSwitch(target)).booleanValue()) continue;
            status.add(CodeGenPlugin.error((String)"Error while examining model changes"));
        }
        status.add(CodeGenPlugin.info((String)("Examined model changes " + (System.currentTimeMillis() - start) + "ms")));
        LinkedHashSet<FileName> srcFileNames = new LinkedHashSet<FileName>();
        for (AbstractElementGenerator gen : generators.values()) {
            srcFileNames.addAll(gen.getGeneratedFilenames());
        }
        this.cpp.setFilenames(srcFileNames);
        start = System.currentTimeMillis();
        this.changeTracker.prune(generators);
        status.add(CodeGenPlugin.info((String)("Prune unchanged elements " + (System.currentTimeMillis() - start) + "ms")));
        for (GeneratorKey key : generators.keySet()) {
            AbstractElementGenerator generator = (AbstractElementGenerator)generators.get(key);
            try {
                start = System.currentTimeMillis();
                if (generator.generate()) {
                    status.add(CodeGenPlugin.info((String)(String.valueOf(generator.getLabel()) + ' ' + (System.currentTimeMillis() - start) + "ms")));
                    this.changeTracker.addAlreadyGenerated(key.kind, (NamedElement)key.object);
                    continue;
                }
                status.add(CodeGenPlugin.error((String)("Error while generating " + generator.getLabel())));
            }
            catch (Exception e) {
                status.add(CodeGenPlugin.error((Throwable)e));
            }
        }
        start = System.currentTimeMillis();
        this.changeTracker.consumeChanges(generators);
        status.add(CodeGenPlugin.info((String)("Consume changes to elements " + (System.currentTimeMillis() - start) + "ms")));
        return status;
    }

    private boolean toBeGenerated(EObject target) {
        if (!(target instanceof NamedElement)) {
            return false;
        }
        NamedElement element = (NamedElement)target;
        if (RTSModelLibraryUtils.isSystemElement((CommonElement)element)) {
            return false;
        }
        Boolean generateBool = RTCppGenerationProperties.getGenerationPropGenerate((CommonElement)element);
        if (generateBool == null) {
            return true;
        }
        return generateBool;
    }

    private class Collector
    extends CommonSwitch<Boolean> {
        private final GeneratorManager genManager = GeneratorManager.getInstance();
        public final Map<GeneratorKey, AbstractElementGenerator> generators;

        public Collector(Map<GeneratorKey, AbstractElementGenerator> generators) {
            this.generators = generators;
        }

        private <T extends NamedElement> boolean createGenerator(Kind kind, T object, T context) {
            GeneratorKey key = new GeneratorKey(kind, (EObject)object, (EObject)context);
            if (this.generators.get(key) != null) {
                return false;
            }
            AbstractElementGenerator generator = this.genManager.getGenerator(kind, XTUMLRT2CppCodeGenerator.this.cpp, object, context);
            if (generator == null) {
                return false;
            }
            this.generators.put(key, generator);
            return true;
        }

        private void assignEmptyStateMachine(Entity entity) {
            if (entity.getBehaviour() == null) {
                StateMachine emptyStateMachine = StatemachFactory.eINSTANCE.createStateMachine();
                entity.setBehaviour((Behaviour)emptyStateMachine);
            }
        }

        private boolean isEmptyStateMachine(Behaviour behaviour) {
            return behaviour == null || behaviour instanceof StateMachine && ((StateMachine)behaviour).getTop() == null;
        }

        public Boolean defaultCase(EObject object) {
            return true;
        }

        public Boolean caseModel(Model model) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)model)) {
                return true;
            }
            for (Entity element : model.getEntities()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : model.getProtocols()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : model.getTypeDefinitions()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : model.getPackages()) {
                this.doSwitch((EObject)element);
            }
            if (model instanceof RTModel) {
                for (Entity element : ((RTModel)model).getContainedArtifacts()) {
                    this.doSwitch((EObject)element);
                }
            }
            return true;
        }

        public Boolean casePackage(Package packge) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)packge)) {
                return true;
            }
            for (Entity element : packge.getEntities()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : packge.getProtocols()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : packge.getTypeDefinitions()) {
                this.doSwitch((EObject)element);
            }
            for (Entity element : packge.getPackages()) {
                this.doSwitch((EObject)element);
            }
            return true;
        }

        public Boolean caseProtocol(Protocol protocol) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)protocol)) {
                return true;
            }
            if (!RTSModelLibraryUtils.isSystemElement((CommonElement)protocol) && this.createGenerator(Kind.Protocol, (T)protocol, (T)null)) {
                for (Signal signal : XTUMLRTUtil.getSignals((Protocol)protocol)) {
                    for (Parameter p : signal.getParameters()) {
                        if (p.getType() == null) continue;
                        this.doSwitch((EObject)p.getType());
                    }
                }
                NamedElement root = XTUMLRTUtil.getRoot((CommonElement)protocol);
                if (root == null) {
                    return true;
                }
                for (Capsule capsule : XTUMLRTUtil.getAllCapsules((EObject)root)) {
                    for (Port port : XTUMLRTUtil.getAllRTPorts((Capsule)capsule)) {
                        if (port.getType() != protocol) continue;
                        this.doSwitch((EObject)capsule);
                    }
                }
            }
            return true;
        }

        public Boolean caseTypeDefinition(TypeDefinition typedef) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)typedef)) {
                return true;
            }
            return (Boolean)this.doSwitch((EObject)typedef.getType());
        }

        public Boolean caseBehaviour(Behaviour behaviour) {
            Kind kind = behaviour instanceof StateMachine ? Kind.StateMachine : Kind.Behaviour;
            EObject eObject = behaviour.eContainer();
            if (eObject instanceof Entity) {
                Entity entity = (Entity)eObject;
                this.createGenerator(kind, (NamedElement)behaviour, (NamedElement)entity);
            }
            return true;
        }

        public Boolean caseStructuredType(StructuredType struct) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)struct)) {
                return true;
            }
            this.createGenerator(Kind.BasicClass, (T)struct, (T)null);
            return true;
        }

        public Boolean caseCapsule(Capsule capsule) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)capsule)) {
                return true;
            }
            this.createGenerator(Kind.Capsule, (T)capsule, (T)null);
            Behaviour behaviour = XTUMLRTUtil.getActualBehaviour((Capsule)capsule);
            if (behaviour != null && !this.isEmptyStateMachine(behaviour) && XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)behaviour)) {
                this.doSwitch((EObject)behaviour);
            } else {
                this.assignEmptyStateMachine((Entity)capsule);
                this.createGenerator(Kind.EmptyStateMachine, (NamedElement)capsule.getBehaviour(), (NamedElement)capsule);
            }
            if (GeneralUtil.getName((EObject)XTUMLRT2CppCodeGenerator.this.top).equals(capsule.getName())) {
                this.createGenerator(Kind.Structural, (T)capsule, (T)null);
            }
            return true;
        }

        public Boolean caseEntity(Entity object) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)object)) {
                return true;
            }
            this.createGenerator(Kind.BasicClass, (T)object, (T)null);
            return true;
        }

        public Boolean caseEnumeration(Enumeration object) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)object)) {
                return true;
            }
            this.createGenerator(Kind.Enum, (T)object, (T)null);
            return true;
        }

        public Boolean caseArtifact(Artifact object) {
            if (!XTUMLRT2CppCodeGenerator.this.toBeGenerated((EObject)object)) {
                return true;
            }
            this.createGenerator(Kind.Artifact, (T)object, (T)null);
            return true;
        }
    }

    protected static class GeneratorKey {
        public final Kind kind;
        public final EObject object;
        public final EObject context;

        public GeneratorKey(Kind kind, EObject object, EObject context) {
            this.kind = kind;
            this.object = object;
            this.context = context;
        }

        public int hashCode() {
            return this.kind.hashCode() ^ this.object.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GeneratorKey)) {
                return false;
            }
            GeneratorKey other = (GeneratorKey)obj;
            if (this.context == null) {
                return this.kind == other.kind && this.object.equals(other.object) && other.context == null;
            }
            return this.kind == other.kind && this.object.equals(other.object) && this.context.equals(other.context);
        }
    }

    public static enum Kind {
        BasicClass("ClassGenerator"),
        Capsule("CapsuleGenerator"),
        Protocol("ProtocolGenerator"),
        Behaviour("BehaviourGenerator"),
        StateMachine("StateMachineGenerator"),
        EmptyStateMachine("EmptyStateMachineGenerator"),
        Enum("EnumGenerator"),
        Artifact("ArtifactGenerator"),
        Structural("StructuralGenerator");

        public final String id;

        private Kind(String id) {
            this.id = id;
        }
    }
}

