/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static <T extends MultiplicityElement & NamedElement> Expression generateBoundExpression(T element) {
        ExpressionBlob result = null;
        String lowerBoundSpec = element.getLowerBound();
        String upperBoundSpec = element.getUpperBound();
        int lowerBound = -1;
        int upperBound = -1;
        int bound = -1;
        boolean parsedLowerBound = true;
        try {
            lowerBound = Integer.parseInt(lowerBoundSpec);
        }
        catch (NumberFormatException numberFormatException) {
            parsedLowerBound = false;
        }
        try {
            bound = upperBound = Integer.parseInt(upperBoundSpec);
            if (parsedLowerBound && lowerBound > upperBound) {
                bound = lowerBound;
            }
            result = new IntegralLiteral(bound);
        }
        catch (NumberFormatException numberFormatException) {
            result = new ExpressionBlob(upperBoundSpec);
        }
        return result;
    }

    public static Expression generateIntegralOrBlob(String s) {
        ExpressionBlob result = null;
        try {
            int i = Integer.parseInt(s);
            result = new IntegralLiteral(i);
        }
        catch (NumberFormatException numberFormatException) {
            result = new ExpressionBlob(s);
        }
        return result;
    }
}

