/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.instance.model.ICapsuleInstance;
import org.eclipse.papyrusrt.codegen.instance.model.IPortInstance;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;

public class PortInstance
implements IPortInstance {
    private final ICapsuleInstance container;
    private final Port type;
    private final List<FarEnd> farEnds;
    private int unconnectedFarEnds;
    private boolean isRelay = false;

    public PortInstance(ICapsuleInstance container, Port type) {
        this.container = container;
        this.type = type;
        this.unconnectedFarEnds = XTUMLRTUtil.getUpperBound((MultiplicityElement)type);
        this.farEnds = new ArrayList<FarEnd>(this.unconnectedFarEnds);
    }

    @Override
    public ICapsuleInstance getContainer() {
        return this.container;
    }

    @Override
    public Port getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public Iterable<? extends IPortInstance.IFarEnd> getFarEnds() {
        return this.farEnds;
    }

    @Override
    public boolean isRelay() {
        return this.isRelay;
    }

    @Override
    public boolean isTopLevelPort() {
        return this.container != null && this.container.getCapsulePart() == null;
    }

    public FarEnd convertToRelay() {
        this.isRelay = true;
        if (this.farEnds.isEmpty()) {
            if (this.unconnectedFarEnds <= 0) {
                throw new RuntimeException("out of port instances, cannot create relay port for " + this.type.getName());
            }
            return this.createFarEnd();
        }
        FarEnd far = this.farEnds.remove(0);
        far.disconnectFrom(this);
        return far;
    }

    public FarEnd createFarEnd() {
        if (this.unconnectedFarEnds <= 0) {
            return null;
        }
        --this.unconnectedFarEnds;
        return new FarEnd(this.farEnds.size());
    }

    public String toString() {
        return String.valueOf(this.container.toString()) + '#' + this.type.getName();
    }

    public class FarEnd
    implements IPortInstance.IFarEnd {
        private final int index;

        public FarEnd(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public ICapsuleInstance getContainer() {
            return PortInstance.this.container;
        }

        @Override
        public Port getType() {
            return PortInstance.this.type;
        }

        @Override
        public void connectWith(IPortInstance.IFarEnd other) {
            PortInstance.this.farEnds.add((FarEnd)other);
        }

        @Override
        public IPortInstance getOwner() {
            return PortInstance.this;
        }

        private boolean isOwnedBy(IPortInstance port) {
            return port == PortInstance.this;
        }

        private FarEnd disconnectFrom(PortInstance other) {
            for (FarEnd far : PortInstance.this.farEnds) {
                if (!far.isOwnedBy(other)) continue;
                PortInstance.this.farEnds.remove(far);
                return far;
            }
            return null;
        }

        public String toString() {
            return String.valueOf(PortInstance.this.toString()) + ".far[" + this.index + ']';
        }
    }
}

