/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.dep;

import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.Dependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.IForwardDeclarable;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.io.CodeFormatter;

public class TypeDependency
extends Dependency {
    private final Type type;

    public TypeDependency(Type type) {
        super(type.isIndirect() ? Dependency.Kind.Reference : Dependency.Kind.Use);
        this.type = type;
    }

    @Override
    protected Element getComparisonElement() {
        return this.type.getElement();
    }

    @Override
    public HeaderFile getHeader() {
        return this.type.getElement().getDefinedIn();
    }

    private static boolean writeInclusion(CodeFormatter fmt, Element element) {
        HeaderFile header = element.getDefinedIn();
        return header == null ? true : header.writeInclude(fmt);
    }

    @Override
    protected int compareReference(Dependency dep) {
        IForwardDeclarable fwdDecl2;
        Element element1 = this.getComparisonElement();
        Element element2 = dep.getComparisonElement();
        if (element1 == null) {
            return element2 == null ? 0 : 1;
        }
        if (element2 == null) {
            return 1;
        }
        IForwardDeclarable fwdDecl1 = element1 instanceof IForwardDeclarable ? (IForwardDeclarable)((Object)element1) : null;
        IForwardDeclarable iForwardDeclarable = fwdDecl2 = element2 instanceof IForwardDeclarable ? (IForwardDeclarable)((Object)element2) : null;
        if (fwdDecl1 != null) {
            return fwdDecl2 == null ? 1 : fwdDecl1.compareTo(fwdDecl2);
        }
        if (fwdDecl2 != null) {
            return -1;
        }
        return this.compareUse(dep);
    }

    @Override
    protected boolean isReferenceProvidedInUse(Dependency use) {
        Element element1 = this.getComparisonElement();
        Element element2 = use.getComparisonElement();
        if (element1 == null || element2 == null) {
            return false;
        }
        HeaderFile header1 = element1.getDefinedIn();
        HeaderFile header2 = element2.getDefinedIn();
        if (header1 == null || header2 == null) {
            return false;
        }
        return header1 == header2;
    }

    @Override
    protected boolean writeReference(CppFormatter fmt) {
        Element element = this.type.getElement();
        if (element instanceof IForwardDeclarable) {
            return ((IForwardDeclarable)((Object)element)).writeForwardDeclaration(fmt);
        }
        return TypeDependency.writeInclusion(fmt, element);
    }

    @Override
    protected int compareUse(Dependency dep) {
        if (dep instanceof DependencyBlob) {
            return -1;
        }
        Element element1 = this.getComparisonElement();
        Element element2 = dep.getComparisonElement();
        if (element1 == null) {
            return element2 == null ? 0 : 1;
        }
        if (element2 == null) {
            return 1;
        }
        HeaderFile header1 = element1.getDefinedIn();
        HeaderFile header2 = element2.getDefinedIn();
        if (header1 == null) {
            return header2 == null ? 0 : -1;
        }
        if (header2 == null) {
            return 1;
        }
        return header1.compareTo(header2);
    }

    @Override
    protected boolean writeUse(CppFormatter fmt) {
        return TypeDependency.writeInclusion(fmt, this.type.getElement());
    }
}

