/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratableElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class MemberField
extends NamedElement
implements IGeneratable,
IGeneratableElement {
    private final Type type;
    private final Expression initializer;
    private boolean isMutable = false;
    private InitKind initKind = InitKind.ASSIGNMENT;

    public MemberField(Type type, String ident) {
        this(type, ident, null);
    }

    public MemberField(Type type, String ident, Expression initializer) {
        super(ident);
        this.type = type;
        this.initializer = initializer;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public InitKind getInitKind() {
        return this.initKind;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        if (this.type.isArray() && !this.type.isPointer()) {
            return this.type.getElement().getType().addDependencies(deps);
        }
        return this.type.addDependencies(deps);
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        return this.addDependencies(deps.decl());
    }

    public void setMutable() {
        this.isMutable = true;
    }

    public void setInitKind(InitKind initKind) {
        this.initKind = initKind;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!(!this.isMutable || fmt.write("mutable") && fmt.space())) {
            return false;
        }
        if (!this.type.write(fmt, this.getName())) {
            return false;
        }
        if (!(this.initKind != InitKind.CONSTANT || fmt.space() && fmt.write('=') && fmt.space() && this.initializer.write(fmt))) {
            return false;
        }
        return fmt.terminate();
    }

    @Override
    public boolean write(CppWriter out) {
        return this.write(out.decl());
    }

    public static enum InitKind {
        ASSIGNMENT,
        CONSTANT,
        CONSTRUCTOR;

    }
}

