/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.external.StandardLibrary;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class OffsetOf
extends Expression {
    private final CppClass cls;
    private final String memberName;

    public OffsetOf(CppClass cls, String memberName) {
        this.cls = cls;
        this.memberName = memberName;
    }

    @Override
    protected Type createType() {
        return StandardLibrary.size_t;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return Expression.Precedence.Lowest;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return deps.add(new ElementDependency(StandardLibrary.offsetof)) && deps.add(new ElementDependency(this.cls));
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return fmt.write("offsetof(") && fmt.space() && fmt.write(this.cls.getName()) && fmt.write(',') && fmt.space() && fmt.write(this.memberName) && fmt.space() && fmt.write(')');
    }
}

