/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class Sizeof
extends Expression {
    private final IGeneratable impl;

    public Sizeof(Type type) {
        this.impl = new SizeofType(type);
    }

    public Sizeof(Element element) {
        this(element.getType());
    }

    public Sizeof(Expression expr) {
        this.impl = new SizeofExpr(expr);
    }

    public Sizeof(Variable var) {
        this(new ElementAccess(var));
    }

    public Sizeof(NamedElement element) {
        this(new ElementAccess(element));
    }

    @Override
    protected Type createType() {
        return PrimitiveType.UINT;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return Expression.Precedence.Default;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.impl.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return this.impl.write(fmt);
    }

    private static class SizeofExpr
    implements IGeneratable {
        private final Expression expr;

        public SizeofExpr(Expression expr) {
            this.expr = expr;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.expr.addDependencies(deps);
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return fmt.write("sizeof(") && fmt.space() && this.expr.write(fmt) && fmt.space() && fmt.write(')');
        }
    }

    private static class SizeofType
    implements IGeneratable {
        private final Type type;

        public SizeofType(Type type) {
            this.type = type;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.type.addDependencies(deps);
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return fmt.write("sizeof(") && fmt.space() && this.type.write(fmt, null) && fmt.space() && fmt.write(')');
        }
    }
}

