/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.stmt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.BreakStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.SwitchClause;

public class SwitchStatement
extends Statement {
    private final Expression condition;
    private final List<SwitchClause> clauses = new ArrayList<SwitchClause>();

    public SwitchStatement(Expression condition) {
        this.condition = condition;
    }

    public void add(SwitchClause clause) {
        if (!clause.isFallthrough() && clause.clauseFallsthrough()) {
            clause.add(new BreakStatement());
        }
        this.clauses.add(clause);
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        if (!this.condition.addDependencies(deps)) {
            return false;
        }
        for (SwitchClause clause : this.clauses) {
            if (clause.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!(fmt.write("switch(") && fmt.space() && this.condition.write(fmt) && fmt.space() && fmt.writeLn(')') && fmt.openBrace() && fmt.decIndent())) {
            return false;
        }
        boolean ret = true;
        for (SwitchClause clause : this.clauses) {
            ret = clause.write(fmt);
            if (!ret) break;
        }
        return fmt.incIndent() && fmt.closeBrace() && ret;
    }
}

