/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.io;

import java.io.IOException;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.lang.io.ComparisonStream;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;

public class CodeFormatter {
    private final ComparisonStream stm;
    private int indentLevel = 0;
    private int indentDisable = 0;
    private static final byte[] Indent = "    ".getBytes();
    private boolean noText = true;
    private String pending = null;

    public static CodeFormatter create(String pathname) {
        ComparisonStream stm = ComparisonStream.create(pathname);
        return stm == null ? null : new CodeFormatter(stm);
    }

    public static CodeFormatter createProvisional(String pathname) {
        ComparisonStream stm = ComparisonStream.createProvisional(pathname);
        return stm == null ? null : new CodeFormatter(stm);
    }

    protected CodeFormatter(ComparisonStream stm) {
        this.stm = stm;
    }

    public boolean markNoText() {
        this.noText = true;
        return true;
    }

    public void clearPending() {
        this.pending = null;
    }

    public void setPending(String p) {
        this.pending = p;
    }

    private void flushPendingFor(char c) {
        if (this.pending == null) {
            return;
        }
        if (c == '\n') {
            while (this.pending.length() > 0) {
                int len = this.pending.length();
                char last = this.pending.charAt(len - 1);
                if (last != ' ') break;
                this.pending = this.pending.substring(0, len - 1);
            }
        }
        if (this.pending.isEmpty()) {
            this.pending = null;
            return;
        }
        String p = this.pending;
        this.pending = null;
        this.write(p);
    }

    public boolean enableIndent() {
        if (this.indentDisable < 1) {
            CodeGenPlugin.error((Throwable)new DetailedException("Code formatting indentation already enabled."));
            return false;
        }
        --this.indentDisable;
        return true;
    }

    public boolean disableIndent() {
        ++this.indentDisable;
        return true;
    }

    public void enableWrites() {
        this.stm.enableWrites();
    }

    public boolean isProvisional() {
        return this.stm.isProvisional();
    }

    public void close() {
        try {
            this.stm.close();
        }
        catch (IOException e) {
            CodeGenPlugin.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(String str) {
        if (str == null) return true;
        if (str.isEmpty()) {
            return true;
        }
        this.flushPendingFor(str.charAt(0));
        try {
            this.writeIndent();
            int lastNewline = 0;
            while (true) {
                if (lastNewline < 0) {
                    return true;
                }
                int nextNewline = str.indexOf(10, lastNewline + 1);
                if (nextNewline < 0) {
                    this.noText = false;
                    this.stm.write(str.substring(lastNewline).getBytes());
                    return true;
                }
                this.noText = false;
                this.stm.write(str.substring(lastNewline, nextNewline).getBytes());
                this.newline();
                lastNewline = nextNewline + 1;
            }
        }
        catch (IOException e) {
            CodeGenPlugin.error((Throwable)e);
            return false;
        }
    }

    public boolean write(char c) {
        this.flushPendingFor(c);
        try {
            if (c != '\n') {
                this.writeIndent();
            }
            this.noText = false;
            this.stm.write((byte)c);
        }
        catch (IOException e) {
            CodeGenPlugin.error((Throwable)e);
            return false;
        }
        return true;
    }

    private boolean writeIndent() {
        if (this.indentDisable == 0 && this.indentLevel > 0 && this.stm.getLastChar() == '\n') {
            int i = 0;
            while (i < this.indentLevel) {
                try {
                    this.stm.write(Indent);
                }
                catch (IOException e) {
                    CodeGenPlugin.error((Throwable)e);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean incIndent() {
        ++this.indentLevel;
        return true;
    }

    public boolean decIndent() {
        --this.indentLevel;
        return true;
    }

    public boolean space() {
        if (this.noText) {
            return true;
        }
        switch (this.getLastChar()) {
            case '\u0000': 
            case '\n': 
            case ' ': {
                return true;
            }
        }
        return this.write(' ');
    }

    private char getLastChar() {
        if (this.pending != null && !this.pending.isEmpty()) {
            return this.pending.charAt(this.pending.length() - 1);
        }
        int last = this.stm.getLastChar();
        if (last != 10) {
            return (char)last;
        }
        return (char)(this.indentDisable == 0 && this.indentLevel > 0 ? 32 : last);
    }

    public boolean spaceUnless(char last) {
        return this.getLastChar() == last || this.write(' ');
    }

    public boolean pendingSpace() {
        if (this.noText) {
            return true;
        }
        if (this.stm.getLastChar() == ' ') {
            return true;
        }
        if (this.pending == null || this.pending.isEmpty()) {
            this.pending = " ";
        } else if (this.pending.charAt(this.pending.length() - 1) != ' ') {
            this.pending = String.valueOf(this.pending) + " ";
        }
        return true;
    }

    public boolean newline() {
        return this.write('\n');
    }

    public boolean terminate() {
        if (this.pending != null && !this.pending.isEmpty()) {
            byte[] p = this.pending.getBytes();
            this.pending = null;
            int i = p.length - 1;
            while (i >= 0) {
                if (p[i] != 32) {
                    this.write(new String(p, 0, i));
                    break;
                }
                --i;
            }
        }
        return this.writeLn(';');
    }

    public boolean openBrace() {
        if (this.stm.getLastChar() != '\n' && !this.newline() || !this.writeLn('{')) {
            return false;
        }
        ++this.indentLevel;
        return true;
    }

    public boolean closeBrace(boolean trailingNewline) {
        --this.indentLevel;
        return !(this.stm.getLastChar() != '\n' && !this.newline() || !this.write('}') || trailingNewline && !this.newline());
    }

    public boolean closeBrace() {
        return this.closeBrace(true);
    }

    public boolean writeLn(char c) {
        return this.write(c) && this.newline();
    }

    public boolean writeLn(String str) {
        return this.write(str) && this.newline();
    }
}

