/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.codegen.papyrus.UMLRTGenerator;
import org.eclipse.papyrusrt.codegen.papyrus.cdt.EditorUtil;
import org.eclipse.papyrusrt.codegen.papyrus.cdt.UMLEObjectLocator;
import org.eclipse.papyrusrt.codegen.papyrus.internal.UMLRTCppCodeGen;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class EditSourceActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object obj = selection.getFirstElement();
            EObject eobj = EMFHelper.getEObject((Object)obj);
            if (eobj == null) {
                throw new IllegalArgumentException(String.valueOf(obj.getClass().getCanonicalName()) + " is not an EObject");
            }
            EObject root = EcoreUtil.getRootContainer((EObject)eobj);
            ArrayList<EObject> targets = new ArrayList<EObject>();
            targets.add(root);
            String top = UMLRTCppCodeGen.getTopCapsuleName((Element)root);
            UMLRTGenerator.getInstance().generate(targets, top, true);
            MultiStatus rc = new MultiStatus("org.eclipse.papyrusrt.codegen.papyrus", 0, "Edit Source Action Status", null);
            if (eobj instanceof OpaqueBehavior) {
                EObject container = eobj.eContainer();
                IFile file = this.getFile((NamedElement)container);
                if (container instanceof Transition) {
                    UserEditableRegion.Label label = this.getLabel(container);
                    EditorUtil.openEditor(file, label, rc);
                } else if (container instanceof State) {
                    UserEditableRegion.Label label = this.getLabel(container);
                    State s = (State)container;
                    if (s.getEntry() == eobj) {
                        label.setType(UMLPackage.Literals.STATE__ENTRY.getName());
                    } else {
                        label.setType(UMLPackage.Literals.STATE__EXIT.getName());
                    }
                    EditorUtil.openEditor(file, label, rc);
                }
            } else {
                UserEditableRegion.Label label = this.getLabel(eobj);
                IFile file = this.getFile((NamedElement)eobj);
                EditorUtil.openEditor(file, label, rc);
            }
        }
        return null;
    }

    public UserEditableRegion.Label getLabel(EObject context) {
        EObject container = context.eContainer();
        UserEditableRegion.Label label = new UserEditableRegion.Label();
        label.setQualifiedName(this.getParentQualifiedName(context));
        if (context instanceof Transition) {
            label.setType(UMLPackage.Literals.TRANSITION.getName().toLowerCase());
            label.setDetails(this.getDetails((Transition)context));
        } else if (context instanceof Constraint) {
            label.setType(UMLPackage.Literals.TRANSITION__GUARD.getName().toLowerCase());
            label.setDetails(this.getDetails((Transition)container));
        } else if (context instanceof Operation) {
            label.setType(UMLPackage.Literals.OPERATION.getName().toLowerCase());
            label.setDetails(((Operation)context).getName());
        } else if (context instanceof State) {
            label.setQualifiedName(String.valueOf(label.getQualifiedName()) + "::" + ((State)context).getName());
            State s = (State)context;
            if (s.getEntry() != null) {
                label.setType(UMLPackage.Literals.STATE__ENTRY.getName());
            } else {
                label.setType(UMLPackage.Literals.STATE__EXIT.getName());
            }
        } else {
            label.setType(UMLPackage.Literals.CLASS.getName());
        }
        label.setUri(context.eResource().getURI().toString());
        return label;
    }

    public String getDetails(Transition transition) {
        String sourceQname = UMLEObjectLocator.getSMQualifiedName((EObject)transition.getSource());
        String targetQname = UMLEObjectLocator.getSMQualifiedName((EObject)transition.getTarget());
        UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(sourceQname, targetQname);
        for (Trigger t : transition.getTriggers()) {
            Operation message;
            ArrayList<String> ports = new ArrayList<String>();
            for (Port p : t.getPorts()) {
                ports.add(p.getName());
            }
            Event event = t.getEvent();
            if (event == null || !(event instanceof CallEvent) || (message = ((CallEvent)event).getOperation()) == null || message.getName() == null) continue;
            details.addTriggerDetail(message.getName(), ports);
        }
        return details.getTagString();
    }

    public String getParentQualifiedName(EObject object) {
        ArrayList<String> names = new ArrayList<String>();
        EObject container = object.eContainer();
        while (container != null) {
            if (container instanceof State && StateUtils.isRTState((State)((State)container))) {
                names.add(0, ((State)container).getName());
            } else if (container instanceof Class && !(container instanceof StateMachine)) {
                names.add(0, ((Class)container).getName());
            } else if (container instanceof Package) {
                names.add(0, ((Package)container).getName());
            }
            container = container.eContainer();
        }
        return String.join((CharSequence)"::", names);
    }

    public IFile getFile(NamedElement element) {
        IProject project = UMLRTGenerator.getInstance().getProject((EObject)element);
        Class clazz = null;
        NamedElement container = element;
        while (container != null) {
            if (container instanceof Class && !(container instanceof StateMachine)) {
                clazz = (Class)container;
                break;
            }
            container = container.eContainer();
        }
        if (clazz != null) {
            IFolder srcFolder = project.getFolder("src");
            return srcFolder.getFile(String.valueOf(clazz.getName()) + ".cc");
        }
        return null;
    }
}

