/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class BuildNotifier {
    protected IProgressMonitor monitor;
    protected boolean cancelling;
    protected float percentComplete;
    protected int workDone;
    protected int totalWork;
    protected String previousSubtask;

    public BuildNotifier(IProgressMonitor monitor, IProject project) {
        this.monitor = monitor;
        this.cancelling = false;
        this.workDone = 0;
        this.totalWork = 1000000;
    }

    public void begin() {
        if (this.monitor != null) {
            this.monitor.beginTask("", this.totalWork);
        }
        this.previousSubtask = null;
    }

    public void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void setCancelling(boolean cancelling) {
        this.cancelling = cancelling;
    }

    public void done() {
        this.updateProgress(1.0f);
        this.subTask("Project synchronization complete");
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.previousSubtask = null;
    }

    public void subTask(String msg) {
        if (msg.equals(this.previousSubtask)) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.subTask(msg);
        }
        this.previousSubtask = msg;
    }

    public void updateProgress(float newPercentComplete) {
        if (newPercentComplete > this.percentComplete) {
            this.percentComplete = Math.min(newPercentComplete, 1.0f);
            int work = Math.round(this.percentComplete * (float)this.totalWork);
            if (work > this.workDone) {
                if (this.monitor != null) {
                    this.monitor.worked(work - this.workDone);
                }
                this.workDone = work;
            }
        }
    }
}

