/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.Activator;

public class ElementTypeUtils {
    public static Boolean matches(EObject element, String elementTypeId) {
        IElementType type = ElementTypeRegistry.getInstance().getType(elementTypeId);
        if (!(type instanceof ISpecializationType)) {
            return false;
        }
        IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
        if (matcher == null) {
            Activator.log.error("no matcher provided for type: " + type, null);
            return false;
        }
        if (matcher.matches(element)) {
            return true;
        }
        return false;
    }

    public static boolean instanceOf(Object object, IElementType elementType) {
        boolean result = elementType instanceof ISpecializationType ? object instanceof EObject && ((ISpecializationType)elementType).getMatcher().matches((EObject)object) : elementType.getEClass().isInstance(object);
        return result;
    }

    public static boolean isTypeCompatible(IElementType type, IElementType referenceType) {
        if (type == null || referenceType == null) {
            return false;
        }
        if (type.equals(referenceType)) {
            return true;
        }
        IElementType[] superTypes = type.getAllSuperTypes();
        if (superTypes.length == 0) {
            return false;
        }
        int i = 0;
        while (i < superTypes.length) {
            IElementType superType = superTypes[i];
            if (referenceType.equals(superType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ICommand getConfigureAsCommand(IElementType type, EObject object) {
        UnexecutableCommand result;
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)type);
        if (edit == null) {
            result = UnexecutableCommand.INSTANCE;
        } else {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)object);
            ConfigureRequest configure = new ConfigureRequest(editingDomain, object, type);
            result = edit.getEditCommand((IEditCommandRequest)configure);
        }
        return result;
    }
}

