/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import com.google.common.base.Strings;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsulePartSetTypeAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature feature = setRequest.getFeature();
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
                Object newValue = ((SetRequest)request).getValue();
                if (newValue instanceof Classifier) {
                    return CapsuleUtils.isCapsule((Classifier)newValue);
                }
                return false;
            }
            return super.approveRequest((IEditCommandRequest)setRequest);
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        SetValueCommand result = null;
        EStructuralFeature feature = request.getFeature();
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
            Object newValue = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            if (newValue instanceof Type && elementToEdit instanceof Property && (Strings.isNullOrEmpty((String)((Property)elementToEdit).getName()) || NewElementUtil.isCreatedElement(elementToEdit))) {
                Property property = (Property)elementToEdit;
                String name = ((Type)newValue).getName();
                if (!Strings.isNullOrEmpty((String)name)) {
                    String newName = NewElementUtil.getUniqueName(property, (Type)newValue);
                    result = new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName));
                }
            }
        }
        return result;
    }
}

