/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class OperationAsMessageEditHelperAdvice
extends AbstractEditHelperAdvice {
    private CallEvent callEvent;

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Operation operation = (Operation)request.getElementToConfigure();
        final String name = null;
        return new ConfigureElementCommand(request){
            private IProgressMonitor progressMonitor;
            private IAdaptable info;

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.progressMonitor = progressMonitor;
                this.info = info;
                this.createCallEvent(operation, name);
                return CommandResult.newOKCommandResult((Object)operation);
            }

            private void createCallEvent(Operation operation2, String name2) throws ExecutionException {
                Package protocolContainer = operation2.getNearestPackage();
                OperationAsMessageEditHelperAdvice.this.callEvent = (CallEvent)this.createElement((Element)protocolContainer, name2, (IElementType)UMLElementTypes.CALL_EVENT, Relation.CHILD);
                OperationAsMessageEditHelperAdvice.this.callEvent.setOperation(operation2);
            }

            private EObject createElement(Element referenceElement, String name2, IElementType elementType, Relation relation) throws ExecutionException {
                if (referenceElement == null) {
                    throw new ExecutionException("Either the referenceElement or the name parameter is null. ");
                }
                EObject newElement = null;
                Package container = referenceElement.getNearestPackage();
                CreateElementRequest createElementRequest = new CreateElementRequest((EObject)container, elementType);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)container);
                if (provider == null) {
                    throw new ExecutionException("Impossible to get the provider from " + container);
                }
                ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
                if (createGMFCommand != null) {
                    if (createGMFCommand.canExecute()) {
                        IStatus status = createGMFCommand.execute(this.progressMonitor, this.info);
                        if (status.isOK()) {
                            newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                            if (newElement == null) {
                                throw new ExecutionException("Element creation problem for " + elementType.getDisplayName() + ".");
                            }
                            return newElement;
                        }
                        throw new ExecutionException("Impossible to create the callEvent");
                    }
                    throw new ExecutionException("Command to create the callEvent is not executable");
                }
                throw new ExecutionException("Impossible to find a command to create the callEvent");
            }
        };
    }

    private static enum Relation {
        CHILD,
        SIBLING,
        PARENT;

    }
}

