/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class PackageEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            return this.approveCreateElementRequest(request);
        }
        if (request instanceof MoveRequest) {
            return this.approveMoveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateElementRequest(IEditCommandRequest request) {
        CreateElementRequest createElementRequest = (CreateElementRequest)request;
        IElementType type = createElementRequest.getElementType();
        Element container = (Element)createElementRequest.getContainer();
        if (!UMLRTProfileUtils.isUMLRTProfileApplied(container)) {
            return super.approveRequest((IEditCommandRequest)createElementRequest);
        }
        IElementType umlEnumerationLiteralType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.EnumerationLiteral");
        if (umlEnumerationLiteralType != null) {
            if (ElementTypeUtils.isTypeCompatible(type, umlEnumerationLiteralType)) {
                return false;
            }
        } else {
            Activator.log.debug("Impossible to find element type for UML EnumerationLiteral");
        }
        return super.approveRequest(request);
    }

    protected boolean approveMoveRequest(IEditCommandRequest request) {
        MoveRequest moveRequest = (MoveRequest)request;
        EObject targetContainer = moveRequest.getTargetContainer();
        if (targetContainer instanceof Element && !UMLRTProfileUtils.isUMLRTProfileApplied((Element)targetContainer)) {
            return super.approveRequest(request);
        }
        Map elementsToMove = moveRequest.getElementsToMove();
        for (Object elementToMove : elementsToMove.keySet()) {
            if (!(elementToMove instanceof EnumerationLiteral)) continue;
            return false;
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        Object result = null;
        CompositeCommand compositeMoveCommand = new CompositeCommand("Composite Move Command");
        Map elementsToMove = request.getElementsToMove();
        if (!elementsToMove.isEmpty()) {
            for (Object elementToMove : elementsToMove.keySet()) {
                Element protocol;
                Package protocolContainer;
                if (!(elementToMove instanceof Collaboration) || (protocolContainer = (protocol = (Element)elementToMove).getNearestPackage()) == null) continue;
                ICommand command = ProtocolContainerUtils.createMoveProtocolContainerCommand(request, (EObject)protocolContainer);
                compositeMoveCommand.add((IUndoableOperation)command);
                request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)true);
            }
        }
        result = compositeMoveCommand.isEmpty() ? super.getAfterMoveCommand(request) : compositeMoveCommand;
        return result;
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand result;
        if (!ProtocolContainerUtils.isProtocolContainer(request.getElementToEdit()) && request.getFeature() instanceof EReference && request.getValue() instanceof List && ((EReference)request.getFeature()).getEReferenceType().isSuperTypeOf(UMLPackage.Literals.PACKAGE) && ((List)request.getValue()).stream().anyMatch(o -> ProtocolUtils.isProtocol((EObject)o))) {
            List newValue = ((List)request.getValue()).stream().map(o -> ProtocolUtils.isProtocol(o) != false ? ProtocolUtils.getProtocolContainer((Collaboration)o) : o).collect(Collectors.toList());
            SetRequest newRequest = new SetRequest(request.getEditingDomain(), request.getElementToEdit(), request.getFeature(), newValue);
            result = new SetValueCommand(newRequest);
            request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)true);
        } else {
            result = super.getBeforeSetCommand(request);
        }
        return result;
    }
}

