/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.types.advice.ProtocolContainerConfigurationCommand;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ProtocolEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(umlRTMessageType)) {
                return true;
            }
            return types.contains(ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Generalization")) || types.contains(ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Connector"));
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        EObject eObject;
        IEditCommandRequest editCommandRequest = request.getEditCommandRequest();
        if (editCommandRequest instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)editCommandRequest;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null || type == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.getBeforeEditContextCommand(request);
            }
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(umlRTMessageType)) {
                GetEditContextCommand command = new GetEditContextCommand(request);
                if (request.getEditContext() instanceof Collaboration) {
                    IHintedType rTMessageTypeIn = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
                    IHintedType rTMessageTypeOut = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
                    IHintedType rTMessageTypeInOut = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
                    if (types.contains(rTMessageTypeIn)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetIn((Collaboration)request.getEditContext()));
                    } else if (types.contains(rTMessageTypeOut)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetOut((Collaboration)request.getEditContext()));
                    } else if (types.contains(rTMessageTypeInOut)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetInOut((Collaboration)request.getEditContext()));
                    } else {
                        return super.getBeforeEditContextCommand(request);
                    }
                }
                return command;
            }
        } else if (editCommandRequest instanceof DestroyElementRequest && (eObject = ((DestroyElementRequest)editCommandRequest).getElementToDestroy()) instanceof Collaboration && ProtocolUtils.isProtocol(eObject).booleanValue()) {
            Package protocolContainerToDestroy = ProtocolUtils.getProtocolContainer((Collaboration)eObject);
            GetEditContextCommand command = new GetEditContextCommand(request);
            command.setEditContext((Object)protocolContainerToDestroy);
            return command;
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(request.getFeature())) {
            EObject elementToEdit = request.getElementToEdit();
            if (!ProtocolUtils.isProtocol(elementToEdit).booleanValue()) {
                return super.getAfterSetCommand(request);
            }
            final Collaboration protocol = (Collaboration)elementToEdit;
            final String newName = request.getValue() != null ? request.getValue().toString() : "Protocol";
            EditElementCommand command = new EditElementCommand("Change Dependents", (EObject)protocol, (IEditCommandRequest)request){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Package protocolContainer = ProtocolUtils.getProtocolContainer(protocol);
                    if (protocolContainer == null) {
                        Activator.log.error("Impossible to find associated ProtocolContainer for " + protocol, null);
                    }
                    protocolContainer.setName(newName);
                    protocol.setName(newName);
                    Interface interfaceIn = ProtocolContainerUtils.getMessageSetIn(protocolContainer);
                    if (interfaceIn != null) {
                        interfaceIn.setName(MessageSetUtils.computeInterfaceInName(newName));
                    } else {
                        Activator.log.error("Impossible to find associated MessageSetIn for " + protocol, null);
                    }
                    Interface interfaceOut = ProtocolContainerUtils.getMessageSetOut(protocolContainer);
                    if (interfaceOut != null) {
                        interfaceOut.setName(MessageSetUtils.computeInterfaceOutName(newName));
                    } else {
                        Activator.log.error("Impossible to find associated MessageSetOut for " + protocol, null);
                    }
                    Interface interfaceInOut = ProtocolContainerUtils.getMessageSetInOut(protocolContainer);
                    if (interfaceInOut != null) {
                        interfaceInOut.setName(MessageSetUtils.computeInterfaceInOutName(newName));
                    } else {
                        Activator.log.error("Impossible to find associated MessageSetInOut for " + protocol, null);
                    }
                    return CommandResult.newOKCommandResult((Object)protocol);
                }
            };
            ICommand superCommand = super.getAfterSetCommand(request);
            if (superCommand != null) {
                return superCommand.compose((IUndoableOperation)command);
            }
            return command;
        }
        return super.getAfterSetCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        Collaboration protocol = (Collaboration)request.getElementToConfigure();
        String name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)"Protocol", (Collection)protocol.eContainer().eContents());
        request.setParameter("nameToSet", (Object)name);
        return new ProtocolContainerConfigurationCommand(request, name, protocol);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        return super.getAfterConfigureCommand(request);
    }
}

