/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import com.google.common.base.Strings;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.SystemElementsUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class RTPortSetTypeAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        boolean result = false;
        if (request instanceof SetRequest) {
            Object newValue;
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature feature = setRequest.getFeature();
            result = UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) ? ((newValue = ((SetRequest)request).getValue()) instanceof EObject ? ProtocolUtils.isProtocol((EObject)newValue).booleanValue() : false) : super.approveRequest((IEditCommandRequest)setRequest);
        } else {
            result = super.approveRequest(request);
        }
        return result;
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Set RTPort Name and Kind");
        EStructuralFeature feature = request.getFeature();
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
            Object newValue = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            if (newValue instanceof Type && elementToEdit instanceof Port) {
                String name;
                ICommand cmd;
                Port port = (Port)elementToEdit;
                if (SystemElementsUtils.isSystemProtocol((Collaboration)newValue) && (cmd = this.getSetSAPKindCommand(port)) != null) {
                    compositeCommand.add((IUndoableOperation)cmd);
                }
                if ((Strings.isNullOrEmpty((String)((Port)elementToEdit).getName()) || NewElementUtil.isCreatedElement(elementToEdit)) && !Strings.isNullOrEmpty((String)(name = ((Type)newValue).getName()))) {
                    String newName = NewElementUtil.getUniqueName((Property)port, (Type)newValue);
                    SetValueCommand setNameCommand = new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName));
                    if (setNameCommand != null) {
                        compositeCommand.add((IUndoableOperation)setNameCommand);
                    }
                }
            }
        }
        return compositeCommand.isEmpty() ? super.getAfterSetCommand(request) : compositeCommand;
    }

    protected ICommand getSetSAPKindCommand(Port serviceAccessPoint) {
        Command command = RTPortUtils.getChangeKindCommand(serviceAccessPoint, RTPortKindEnum.SAP);
        ICommand cmd = EMFtoGMFCommandWrapper.wrap((Command)command);
        return cmd;
    }
}

