/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class CapsuleUtils {
    public static final String UML_RT_CAPSULE_DIAGRAM = "UML-RT Capsule Structure Diagram";

    private CapsuleUtils() {
    }

    public static boolean isCapsule(Classifier classifier) {
        return ElementTypeUtils.matches((EObject)classifier, "org.eclipse.papyrusrt.umlrt.core.Capsule");
    }

    public static Class getSuperCapsule(BehavioredClassifier capsule) {
        Class result = null;
        if (CapsuleUtils.isCapsule((Classifier)capsule)) {
            for (Classifier next : capsule.getGenerals()) {
                if (!CapsuleUtils.isCapsule(next)) continue;
                result = (Class)next;
                break;
            }
        }
        return result;
    }

    public static Class getContextCapsule(Behavior behavior) {
        Class result = null;
        BehavioredClassifier context = behavior.getContext();
        if (context instanceof Class && CapsuleUtils.isCapsule((Classifier)context)) {
            result = (Class)context;
        }
        return result;
    }

    public static <B extends Behavior> B getSuperBehavior(B capsuleBehavior) {
        Behavior result = null;
        Class capsule = CapsuleUtils.getContextCapsule(capsuleBehavior);
        if (capsule != null) {
            for (Behavior next : capsuleBehavior.getRedefinedBehaviors()) {
                Behavior nextAsB;
                Class superCapsule;
                if (next.eClass() != capsuleBehavior.eClass() || (superCapsule = CapsuleUtils.getContextCapsule(next)) == null || !capsule.allParents().contains((Object)superCapsule)) continue;
                result = nextAsB = next;
                break;
            }
        }
        return (B)result;
    }

    public static <V extends Vertex> V getSuperVertex(V capsuleStateMachineVertex) {
        Region superRegion;
        V vertex;
        Region region;
        Vertex result = null;
        if (capsuleStateMachineVertex instanceof State) {
            result = (Vertex)TypeUtils.as((Object)((State)capsuleStateMachineVertex).getRedefinedState(), capsuleStateMachineVertex.getClass());
        } else if (capsuleStateMachineVertex instanceof Vertex && (region = (vertex = capsuleStateMachineVertex).getContainer()) != null && (superRegion = region.getExtendedRegion()) != null) {
            result = superRegion.getSubvertex(vertex.getName(), false, vertex.eClass(), false);
        }
        Vertex _result = result;
        return (V)_result;
    }

    public static Transition getSuperTransition(Transition capsuleStateMachineTransition) {
        return capsuleStateMachineTransition.getRedefinedTransition();
    }

    public static Region getSuperRegion(Region capsuleStateMachineRegion) {
        return capsuleStateMachineRegion.getExtendedRegion();
    }

    public static <E extends EObject> boolean redefines(E element, E inherited) {
        return (Boolean)new UMLRTRedefinitionSwitch(inherited).doSwitch(element);
    }

    private static class UMLRTRedefinitionSwitch
    extends UMLSwitch<Boolean> {
        private final EObject inherited;

        UMLRTRedefinitionSwitch(EObject inherited) {
            this.inherited = inherited;
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }

        public Boolean caseStateMachine(StateMachine object) {
            if (CapsuleUtils.getSuperBehavior(object) == this.inherited) {
                return true;
            }
            return false;
        }

        public Boolean caseRegion(Region object) {
            if (CapsuleUtils.getSuperRegion(object) == this.inherited) {
                return true;
            }
            return false;
        }

        public Boolean caseTransition(Transition object) {
            if (CapsuleUtils.getSuperTransition(object) == this.inherited) {
                return true;
            }
            return false;
        }

        public Boolean caseVertex(Vertex object) {
            if (CapsuleUtils.getSuperVertex(object) == this.inherited) {
                return true;
            }
            return false;
        }
    }
}

