/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class MessageSetUtils {
    public static RTMessageKind getMessageKind(Object object) {
        RTMessageSet set;
        if (object instanceof RTMessageSet) {
            return ((RTMessageSet)object).getRtMsgKind();
        }
        if (object instanceof Element && (set = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)((Element)object), RTMessageSet.class)) != null) {
            return set.getRtMsgKind();
        }
        return null;
    }

    public static String computeInterfaceInName(String protocolName) {
        return protocolName;
    }

    public static String computeInterfaceOutName(String protocolName) {
        return String.valueOf(protocolName) + "~";
    }

    public static String computeInterfaceInOutName(String protocolName) {
        return String.valueOf(protocolName) + "IO";
    }

    public static boolean isRTMessageSet(Element owner) {
        return ElementTypeUtils.matches((EObject)owner, "org.eclipse.papyrusrt.umlrt.core.RTMessageSet");
    }

    public static Package getProtocolContainer(Interface messageSet) {
        return messageSet.getNearestPackage();
    }

    public static Collaboration getProtocol(Interface messageSet) {
        Package nearestPackage = MessageSetUtils.getProtocolContainer(messageSet);
        if (nearestPackage != null && ProtocolContainerUtils.isProtocolContainer((EObject)nearestPackage)) {
            return ProtocolContainerUtils.getProtocol(nearestPackage);
        }
        return null;
    }
}

