/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;

public enum RTPortKindEnum implements Comparable<RTPortKindEnum>
{
    EXTERNAL(0, "External Behavior"),
    INTERNAL(1, "Internal Behavior"),
    RELAY(2, "Relay"),
    SAP(3, "SAP"),
    SPP(4, "SPP");

    private final String label;
    private final int index;

    public String getLabel() {
        return this.label;
    }

    public int getIndex() {
        return this.index;
    }

    private RTPortKindEnum(int index, String label) {
        this.label = label;
        this.index = index;
    }

    public String toString() {
        return this.label;
    }

    public static RTPortKindEnum of(IElementType elementType) {
        RTPortKindEnum result = null;
        if (elementType != null && ElementTypeUtils.isTypeCompatible(elementType, (IElementType)UMLRTElementTypesEnumerator.RT_PORT)) {
            if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.InternalBehaviorPort"))) {
                result = INTERNAL;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ExternalBehaviorPort"))) {
                result = EXTERNAL;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint"))) {
                result = SPP;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint"))) {
                result = SAP;
            } else if (ElementTypeUtils.isTypeCompatible(elementType, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RelayPort"))) {
                result = RELAY;
            }
        }
        return result;
    }

    public IHintedType toElementType() {
        IHintedType result;
        switch (this) {
            case EXTERNAL: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ExternalBehaviorPort");
                break;
            }
            case INTERNAL: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.InternalBehaviorPort");
                break;
            }
            case RELAY: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RelayPort");
                break;
            }
            case SAP: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint");
                break;
            }
            case SPP: {
                result = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint");
                break;
            }
            default: {
                result = UMLRTElementTypesEnumerator.RT_PORT;
            }
        }
        return result;
    }

    public boolean isExternal() {
        boolean result;
        switch (this) {
            case EXTERNAL: 
            case RELAY: 
            case SPP: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isInternal() {
        boolean result;
        switch (this) {
            case INTERNAL: 
            case SAP: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

