/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.cpp.defaultlanguage;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.utils.PackageUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;

public class UMLRTCppDefaultLanguage
implements IDefaultLanguage {
    private static final String UMLRT_BASE_PROTOCOL_NAME = "UMLRTBaseCommProtocol";
    private static final String INTERNAL_PACKAGE_NAME = "Internal";
    private static final String CPP_PROPERTIES_PROFILE_PATH = "pathmap://UMLRT_CPP/RTCppProperties.profile.uml";
    private static final String CPP_ICON_URL = "platform:/plugin/org.eclipse.papyrusrt.umlrt.cpp/icons/cpp.gif";
    private static final String CPP = "umlrt-cpp";
    private static final String CPP_PRIMITIVE_TYPES_URI = "pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml";
    private static final String CPP_MODEL_LIBRARY_URI = "pathmap://UMLRTRTSLIB/UMLRT-RTS.uml";

    public String getId() {
        return CPP;
    }

    public String getName() {
        return "C++";
    }

    public String getIconURL() {
        return CPP_ICON_URL;
    }

    public Set<String> getProfilesToApply() {
        return Collections.singleton(CPP_PROPERTIES_PROFILE_PATH);
    }

    public Set<String> getLibrariesToImport() {
        return Collections.singleton(CPP_PRIMITIVE_TYPES_URI);
    }

    public Set<Type> getSpecificPrimitiveTypes(ResourceSet resourceSet) {
        HashSet<Type> set = new HashSet<Type>();
        URI uri = URI.createURI((String)CPP_PRIMITIVE_TYPES_URI);
        if (uri != null) {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null || resource.getContents().isEmpty()) {
                Activator.log.trace("defaultLanguage", "Impossible to get a resource or its content: " + resource);
                return Collections.emptySet();
            }
            if (resource.getContents().size() > 0) {
                for (EObject root : resource.getContents()) {
                    if (!(root instanceof Package)) continue;
                    for (EObject object : ((Package)root).getOwnedTypes()) {
                        if (!(object instanceof Type)) continue;
                        set.add((Type)object);
                    }
                }
            } else {
                Activator.log.error("Impossible to get content of the Cpp Library", null);
            }
            return set;
        }
        return Collections.emptySet();
    }

    public Set<Collaboration> getSystemProtocols(ResourceSet resourceSet) {
        URI uri = URI.createURI((String)CPP_MODEL_LIBRARY_URI);
        if (uri != null) {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null || resource.getContents().isEmpty()) {
                Activator.log.trace("defaultLanguage", "Impossible to get a resource or its content: " + resource);
                return Collections.emptySet();
            }
            if (resource.getContents().size() > 0) {
                HashSet<Collaboration> set = new HashSet<Collaboration>();
                for (EObject root : resource.getContents()) {
                    if (!(root instanceof Package)) continue;
                    return PackageUtils.getProtocols((Package)((Package)root));
                }
                return set;
            }
            Activator.log.error("Impossible to get content of the Model Library", null);
        }
        return Collections.emptySet();
    }

    public Collaboration getBaseProtocol(ResourceSet resourceSet) {
        URI uri = URI.createURI((String)CPP_MODEL_LIBRARY_URI);
        if (uri != null) {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null || resource.getContents().isEmpty()) {
                Activator.log.trace("defaultLanguage", "Impossible to get a resource or its content: " + resource);
                return null;
            }
            if (resource.getContents().size() > 0) {
                for (EObject root : resource.getContents()) {
                    Package internalPackage;
                    if (!(root instanceof Package) || (internalPackage = ((Package)root).getNestedPackage(INTERNAL_PACKAGE_NAME)) == null) continue;
                    return PackageUtils.getProtocol((Package)internalPackage, (String)UMLRT_BASE_PROTOCOL_NAME);
                }
            } else {
                Activator.log.error("Impossible to get content of the Model Library", null);
            }
        }
        return null;
    }

    public Set<Class> getSystemClasses(ResourceSet resourceSet) {
        URI uri = URI.createURI((String)CPP_MODEL_LIBRARY_URI);
        if (uri != null) {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null || resource.getContents().isEmpty()) {
                Activator.log.trace("defaultLanguage", "Impossible to get a resource or its content: " + resource);
                return Collections.emptySet();
            }
            if (resource.getContents().size() > 0) {
                HashSet<Class> set = new HashSet<Class>();
                for (EObject root : resource.getContents()) {
                    if (!(root instanceof Package)) continue;
                    for (PackageableElement element : ((Package)root).getPackagedElements()) {
                        if (!(element instanceof Class)) continue;
                        set.add((Class)element);
                    }
                }
                return set;
            }
            Activator.log.error("Impossible to get content of the Model Library", null);
        }
        return Collections.emptySet();
    }
}

