/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.canonical;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;

class CanonicalRefreshListener<E extends EObject>
implements NotificationListener {
    private static final Map<EditPart, Runnable> pendingRefreshes = new ConcurrentHashMap<EditPart, Runnable>();
    private final Reference<View> hostView;
    private final Reference<E> dependency;
    private final int hashCode;
    private final NotificationFilter filter;

    CanonicalRefreshListener(View hostView, E dependency) {
        this(hostView, dependency, null);
    }

    CanonicalRefreshListener(View hostView, E dependency, NotificationFilter filter) {
        this.hostView = new WeakReference<View>(hostView);
        this.dependency = new WeakReference<E>(dependency);
        this.filter = filter == null ? NotificationFilter.NOT_TOUCH : filter;
        this.hashCode = Objects.hash(hostView, dependency);
    }

    public void notifyChanged(Notification notification) {
        View hostView;
        EObject dependency = (EObject)this.dependency.get();
        if (notification.getNotifier() == dependency && this.filter.matches(notification) && (hostView = this.hostView.get()) != null) {
            this.refreshCanonical(hostView);
        }
    }

    void refreshCanonical(View hostView) {
        for (final EditPart ep : DiagramEditPartsUtil.findEditParts((View)hostView)) {
            if (!ep.isActive() || pendingRefreshes.containsKey(ep)) continue;
            Runnable refresh = new Runnable(){

                @Override
                public void run() {
                    EditPolicy canonical;
                    pendingRefreshes.remove(ep);
                    if (ep.isActive() && (canonical = ep.getEditPolicy((Object)"Canonical")) instanceof CanonicalEditPolicy) {
                        ((CanonicalEditPolicy)canonical).refresh();
                    }
                }
            };
            pendingRefreshes.put(ep, refresh);
            DiagramHelper.asyncExec((EditPart)ep, (Runnable)refresh);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof CanonicalRefreshListener) {
            CanonicalRefreshListener other = (CanonicalRefreshListener)obj;
            result = Objects.equals(other.hostView.get(), this.hostView.get()) && Objects.equals(other.dependency.get(), this.dependency.get());
        }
        return result;
    }
}

